/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.Memory;
import cern.entwined.TransactionAdapter;
import cern.entwined.Utils;
import cern.entwined.exception.NoTransactionException;

public class GlobalReference<T> {
    private final Memory<?> memory;
    private final Long id;

    public GlobalReference(final Memory<?> memory, final T object) {
        Utils.checkNull("Memory", memory);
        this.memory = memory;
        this.id = memory.getNextId();
        try {
            memory.getBaseSnapshot().getGlobalMap().put(this.id, object);
        }
        catch (NoTransactionException ex) {
            TransactionAdapter<Object> atomic = new TransactionAdapter<Object>(){

                @Override
                public boolean run(Object snapshot) {
                    memory.getBaseSnapshot().getGlobalMap().put(GlobalReference.this.id, object);
                    return true;
                }
            };
            this.memory.runTransaction(atomic);
        }
    }

    public T get() {
        try {
            return (T)this.memory.getBaseSnapshot().getGlobalMap().get(this.id);
        }
        catch (NoTransactionException ex) {
            throw new NoTransactionException("Cannot read from GlobalReference outside of a transaction", ex);
        }
    }

    public T set(T newValue) {
        try {
            return (T)this.memory.getBaseSnapshot().getGlobalMap().put(this.id, newValue);
        }
        catch (NoTransactionException ex) {
            throw new NoTransactionException("Cannot write to GlobalReference outside of a transaction", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (null != this.memory) {
                TransactionAdapter cleanup = new TransactionAdapter(){

                    @Override
                    public boolean run(Object snapshot) {
                        GlobalReference.this.memory.getBaseSnapshot().getGlobalMap().remove(GlobalReference.this.id);
                        return true;
                    }
                };
                this.memory.runTransaction(cleanup);
            }
        }
        finally {
            super.finalize();
        }
    }

    Long getId() {
        return this.id;
    }
}

