/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.SemiPersistent;
import cern.entwined.Utils;

public abstract class Snapshot<T extends Snapshot<T>>
extends SemiPersistent<T>
implements Comparable<T> {
    protected final long timestamp;

    protected Snapshot(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Illegal timestamp value, it must be greater than zero");
        }
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(T otherSnapshot) {
        Utils.checkNull("Other snapshot", otherSnapshot);
        if (otherSnapshot.getClass() != this.getClass()) {
            throw new ClassCastException("Cannot compare with " + otherSnapshot.getClass());
        }
        return (int)(this.timestamp - ((Snapshot)otherSnapshot).timestamp);
    }
}

