/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.Ref;
import cern.entwined.SemiPersistent;
import cern.entwined.Utils;
import cern.entwined.exception.ConflictException;

public class TransactionalRef<T>
extends SemiPersistent<TransactionalRef<T>>
implements Ref<T> {
    private boolean accessed = false;
    private boolean updated = false;
    private final T sourceValue;
    private T value = null;

    public TransactionalRef() {
        this(null);
    }

    public TransactionalRef(T value) {
        this.sourceValue = value;
        this.value = this.sourceValue;
    }

    @Override
    public T assoc(T newValue) {
        this.accessed = true;
        this.updated = true;
        T oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    public T deref() {
        this.accessed = true;
        return this.value;
    }

    @Override
    public TransactionalRef<T> cleanCopy() {
        return new TransactionalRef<T>(this.sourceValue);
    }

    @Override
    protected TransactionalRef<T> dirtyCopy() {
        TransactionalRef<T> copy = new TransactionalRef<T>(this.sourceValue);
        copy.accessed = this.accessed;
        copy.updated = this.updated;
        copy.value = this.value;
        return copy;
    }

    @Override
    protected void update(TransactionalRef<T> changes, boolean onlyReadLogs) {
        Utils.checkNull("Local changes", changes);
        if (changes.sourceValue != this.sourceValue) {
            throw new IllegalArgumentException("Updates are only possible for references with the same source");
        }
        this.accessed = changes.accessed;
        if (!onlyReadLogs) {
            this.updated = changes.updated;
            this.value = changes.value;
        }
    }

    @Override
    public TransactionalRef<T> commit(TransactionalRef<T> globalState) {
        Utils.checkNull("Transactional reference", globalState);
        if (globalState.accessed) {
            throw new IllegalArgumentException("Global state must be commited before calling this method");
        }
        if (this.accessed && globalState.sourceValue != this.sourceValue) {
            throw new ConflictException("Conflicting update detected");
        }
        if (!this.updated) {
            return globalState;
        }
        return new TransactionalRef<T>(this.value);
    }
}

