/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined.exception;

import cern.entwined.exception.Unwrappable;

public class UnwrappableException
extends RuntimeException
implements Unwrappable<UnwrappableException> {
    private static final long serialVersionUID = 1L;
    private boolean unwrap = true;

    public UnwrappableException() {
        super("No message");
    }

    public UnwrappableException(String message) {
        super(message);
    }

    public UnwrappableException(String message, Throwable cause) {
        super(UnwrappableException.getRightMessage(message, cause), UnwrappableException.getRightException(cause));
    }

    public UnwrappableException(Throwable cause) {
        super(UnwrappableException.getRightMessage(null, cause), UnwrappableException.getRightException(cause));
    }

    @Override
    public boolean getUnwrap() {
        return this.unwrap;
    }

    @Override
    public UnwrappableException setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
        return this;
    }

    public static Throwable getRightException(Throwable cause) {
        if (null == cause || null == cause.getCause()) {
            return cause;
        }
        if (cause instanceof Unwrappable) {
            if (((Unwrappable)((Object)cause)).getUnwrap()) {
                return cause.getCause();
            }
            if (cause.getClass().equals(cause.getCause().getClass())) {
                return cause.getCause();
            }
        }
        return cause;
    }

    public static String getRightMessage(String message, Throwable cause) {
        String oldMessage = null;
        if (null == cause) {
            return message;
        }
        oldMessage = cause.getMessage();
        if (null == oldMessage) {
            oldMessage = null == cause.getCause() ? oldMessage : cause.getCause().getMessage();
        }
        String fullMessage = message;
        fullMessage = oldMessage != null ? (null != fullMessage ? fullMessage + ", " + oldMessage : oldMessage) : (null != fullMessage ? fullMessage + ", " + cause.toString() : cause.toString());
        return fullMessage;
    }
}

