/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.AuthToken;

public class AuthenticationToken
extends AuthToken {
    public static final AuthenticationToken ANONYMOUS = new AuthenticationToken();

    private AuthenticationToken() {
    }

    private AuthenticationToken(AuthToken token) {
        super(token.getUserName(), token.getName(), token.getType());
        this.setExpires(token.getExpires());
    }

    public AuthenticationToken(String userName, String principal, String type) {
        super(userName, principal, type);
    }

    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            super.setExpires(expires);
        }
    }

    public boolean isExpired() {
        return super.isExpired();
    }

    public static AuthenticationToken parse(String tokenStr) throws AuthenticationException {
        return new AuthenticationToken(AuthToken.parse((String)tokenStr));
    }
}

