/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Random;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestRandomSignerSecretProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndRollSecrets() throws Exception {
        long rolloverFrequency = 15000L;
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret1 = Long.toString(rand.nextLong()).getBytes();
        byte[] secret2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secret3 = Long.toString(rand.nextLong()).getBytes();
        RandomSignerSecretProvider secretProvider = new RandomSignerSecretProvider(seed);
        try {
            secretProvider.init(null, null, rolloverFrequency);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assert.assertNull((Object)allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
        }
        finally {
            secretProvider.destroy();
        }
    }
}

