/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class S3Credentials {
    private String accessKey;
    private String secretAccessKey;

    public void initialize(URI uri, Configuration conf) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid hostname in URI " + uri);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                this.accessKey = userInfo.substring(0, index);
                this.secretAccessKey = userInfo.substring(index + 1);
            } else {
                this.accessKey = userInfo;
            }
        }
        String scheme = uri.getScheme();
        String accessKeyProperty = String.format("fs.%s.awsAccessKeyId", scheme);
        String secretAccessKeyProperty = String.format("fs.%s.awsSecretAccessKey", scheme);
        if (this.accessKey == null) {
            this.accessKey = conf.getTrimmed(accessKeyProperty);
        }
        if (this.secretAccessKey == null) {
            this.secretAccessKey = conf.getTrimmed(secretAccessKeyProperty);
        }
        if (this.accessKey == null && this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a " + scheme + " URL, or by setting the " + accessKeyProperty + " or " + secretAccessKeyProperty + " properties (respectively).");
        }
        if (this.accessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID must be specified as the username of a " + scheme + " URL, or by setting the " + accessKeyProperty + " property.");
        }
        if (this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Secret Access Key must be specified as the password of a " + scheme + " URL, or by setting the " + secretAccessKeyProperty + " property.");
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }
}

