/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.INode;
import org.apache.hadoop.fs.s3.Jets3tFileSystemStore;
import org.apache.hadoop.fs.s3.MigrationTool;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MigrationTool
extends Configured
implements Tool {
    private S3Service s3Service;
    private S3Bucket bucket;

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new MigrationTool(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: MigrationTool <S3 file system URI>");
            System.err.println("\t<S3 file system URI>\tfilesystem to migrate");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        URI uri = URI.create(args[0]);
        this.initialize(uri);
        Jets3tFileSystemStore newStore = new Jets3tFileSystemStore();
        newStore.initialize(uri, this.getConf());
        if (this.get("%2F") != null) {
            System.err.println("Current version number is [unversioned].");
            System.err.println("Target version number is " + newStore.getVersion() + ".");
            UnversionedStore oldStore = new UnversionedStore(this);
            this.migrate((Store)oldStore, (FileSystemStore)newStore);
            return 0;
        }
        S3Object root = this.get("/");
        if (root != null) {
            String version = (String)root.getMetadata("fs-version");
            if (version == null) {
                System.err.println("Can't detect version - exiting.");
            } else {
                String newVersion = newStore.getVersion();
                System.err.println("Current version number is " + version + ".");
                System.err.println("Target version number is " + newVersion + ".");
                if (version.equals(newStore.getVersion())) {
                    System.err.println("No migration required.");
                    return 0;
                }
                System.err.println("Not currently implemented.");
                return 0;
            }
        }
        System.err.println("Can't detect version - exiting.");
        return 0;
    }

    public void initialize(URI uri) throws IOException {
        try {
            String accessKey = null;
            String secretAccessKey = null;
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                int index = userInfo.indexOf(58);
                if (index != -1) {
                    accessKey = userInfo.substring(0, index);
                    secretAccessKey = userInfo.substring(index + 1);
                } else {
                    accessKey = userInfo;
                }
            }
            if (accessKey == null) {
                accessKey = this.getConf().get("fs.s3.awsAccessKeyId");
            }
            if (secretAccessKey == null) {
                secretAccessKey = this.getConf().get("fs.s3.awsSecretAccessKey");
            }
            if (accessKey == null && secretAccessKey == null) {
                throw new IllegalArgumentException("AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a s3 URL, or by setting the fs.s3.awsAccessKeyId or fs.s3.awsSecretAccessKey properties (respectively).");
            }
            if (accessKey == null) {
                throw new IllegalArgumentException("AWS Access Key ID must be specified as the username of a s3 URL, or by setting the fs.s3.awsAccessKeyId property.");
            }
            if (secretAccessKey == null) {
                throw new IllegalArgumentException("AWS Secret Access Key must be specified as the password of a s3 URL, or by setting the fs.s3.awsSecretAccessKey property.");
            }
            AWSCredentials awsCredentials = new AWSCredentials(accessKey, secretAccessKey);
            this.s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception((Throwable)e);
        }
        this.bucket = new S3Bucket(uri.getHost());
    }

    private void migrate(Store oldStore, FileSystemStore newStore) throws IOException {
        for (Path path : oldStore.listAllPaths()) {
            INode inode = oldStore.retrieveINode(path);
            oldStore.deleteINode(path);
            newStore.storeINode(path, inode);
        }
    }

    private S3Object get(String key) {
        try {
            return this.s3Service.getObject(this.bucket.getName(), key);
        }
        catch (S3ServiceException e) {
            if ("NoSuchKey".equals(e.getS3ErrorCode())) {
                return null;
            }
            return null;
        }
    }

    static /* synthetic */ S3Bucket access$000(MigrationTool x0) {
        return x0.bucket;
    }

    static /* synthetic */ S3Service access$100(MigrationTool x0) {
        return x0.s3Service;
    }
}

