/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.staging;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.staging.ConflictResolution;
import org.apache.hadoop.fs.s3a.commit.staging.StagingCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryStagingCommitter
extends StagingCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryStagingCommitter.class);
    public static final String NAME = "directory";

    public DirectoryStagingCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        super.setupJob(context);
        Path outputPath = this.getOutputPath();
        FileSystem fs = this.getDestFS();
        if (this.getConflictResolutionMode(context, fs.getConf()) == ConflictResolution.FAIL && fs.exists(outputPath)) {
            throw this.failDestinationExists(outputPath, "Setting job as " + this.getRole());
        }
    }

    @Override
    protected void preCommitJob(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        Path outputPath = this.getOutputPath();
        FileSystem fs = this.getDestFS();
        Configuration fsConf = fs.getConf();
        switch (this.getConflictResolutionMode(context, fsConf)) {
            case FAIL: {
                break;
            }
            case APPEND: {
                break;
            }
            case REPLACE: {
                if (!fs.delete(outputPath, true)) break;
                LOG.info("{}: removed output path to be replaced: {}", (Object)this.getRole(), (Object)outputPath);
                break;
            }
            default: {
                throw new IOException(this.getRole() + ": unknown conflict resolution mode: " + (Object)((Object)this.getConflictResolutionMode(context, fsConf)));
            }
        }
    }
}

