/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBClientFactory;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class S3Guard {
    private static final Logger LOG = LoggerFactory.getLogger(S3Guard.class);
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static final String S3GUARD_DDB_CLIENT_FACTORY_IMPL = "fs.s3a.s3guard.ddb.client.factory.impl";
    static final Class<? extends DynamoDBClientFactory> S3GUARD_DDB_CLIENT_FACTORY_IMPL_DEFAULT = DynamoDBClientFactory.DefaultDynamoDBClientFactory.class;
    private static final FileStatus[] EMPTY_LISTING = new FileStatus[0];

    private S3Guard() {
    }

    public static MetadataStore getMetadataStore(FileSystem fs) throws IOException {
        Preconditions.checkNotNull((Object)fs);
        Configuration conf = fs.getConf();
        Preconditions.checkNotNull((Object)conf);
        try {
            Class<? extends MetadataStore> msClass = S3Guard.getMetadataStoreClass(conf);
            MetadataStore msInstance = (MetadataStore)ReflectionUtils.newInstance(msClass, (Configuration)conf);
            LOG.debug("Using {} metadata store for {} filesystem", (Object)msClass.getSimpleName(), (Object)fs.getScheme());
            msInstance.initialize(fs);
            return msInstance;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            String message = "Failed to instantiate metadata store " + conf.get("fs.s3a.metadatastore.impl") + " defined in " + "fs.s3a.metadatastore.impl" + ": " + e;
            LOG.error(message, (Throwable)e);
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(message, e);
        }
    }

    static Class<? extends MetadataStore> getMetadataStoreClass(Configuration conf) {
        if (conf == null) {
            return NullMetadataStore.class;
        }
        if (conf.get("fs.s3a.metadatastore.impl") != null && LOG.isDebugEnabled()) {
            LOG.debug("Metastore option source {}", (Object[])conf.getPropertySources("fs.s3a.metadatastore.impl"));
        }
        Class aClass = conf.getClass("fs.s3a.metadatastore.impl", NullMetadataStore.class, MetadataStore.class);
        return aClass;
    }

    public static S3AFileStatus putAndReturn(MetadataStore ms, S3AFileStatus status, S3AInstrumentation instrumentation) throws IOException {
        long startTimeNano = System.nanoTime();
        ms.put(new PathMetadata(status));
        instrumentation.addValueToQuantiles(Statistic.S3GUARD_METADATASTORE_PUT_PATH_LATENCY, System.nanoTime() - startTimeNano);
        instrumentation.incrementCounter(Statistic.S3GUARD_METADATASTORE_PUT_PATH_REQUEST, 1L);
        return status;
    }

    public static FileStatus[] dirMetaToStatuses(DirListingMetadata dirMeta) {
        if (dirMeta == null) {
            return EMPTY_LISTING;
        }
        Collection<PathMetadata> listing = dirMeta.getListing();
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (PathMetadata pm : listing) {
            if (pm.isDeleted()) continue;
            statuses.add(pm.getFileStatus());
        }
        return statuses.toArray(new FileStatus[0]);
    }

    public static FileStatus[] dirListingUnion(MetadataStore ms, Path path, List<FileStatus> backingStatuses, DirListingMetadata dirMeta, boolean isAuthoritative) throws IOException {
        if (S3Guard.isNullMetadataStore(ms)) {
            return backingStatuses.toArray(new FileStatus[backingStatuses.size()]);
        }
        S3Guard.assertQualified(path);
        if (dirMeta == null) {
            dirMeta = new DirListingMetadata(path, DirListingMetadata.EMPTY_DIR, false);
        }
        Set<Path> deleted = dirMeta.listTombstones();
        boolean changed = false;
        for (FileStatus s : backingStatuses) {
            if (deleted.contains(s.getPath())) continue;
            boolean updated = dirMeta.put(s);
            changed = changed || updated;
        }
        boolean bl = changed = changed || !dirMeta.isAuthoritative() && isAuthoritative;
        if (changed && isAuthoritative) {
            dirMeta.setAuthoritative(true);
            ms.put(dirMeta);
        }
        return S3Guard.dirMetaToStatuses(dirMeta);
    }

    public static boolean isNullMetadataStore(MetadataStore ms) {
        return ms instanceof NullMetadataStore;
    }

    @Deprecated
    public static void makeDirsOrdered(MetadataStore ms, List<Path> dirs, String owner, boolean authoritative) {
        if (dirs == null) {
            return;
        }
        S3AFileStatus prevStatus = null;
        ArrayList<PathMetadata> pathMetas = new ArrayList<PathMetadata>(dirs.size());
        try {
            for (int i = 0; i < dirs.size(); ++i) {
                boolean isLeaf = prevStatus == null;
                Path f = dirs.get(i);
                S3Guard.assertQualified(f);
                S3AFileStatus status = S3AUtils.createUploadFileStatus(f, true, 0L, 0L, owner);
                DirListingMetadata dirMeta = null;
                if (authoritative) {
                    Collection<PathMetadata> children;
                    if (isLeaf) {
                        children = DirListingMetadata.EMPTY_DIR;
                    } else {
                        children = new ArrayList<PathMetadata>(1);
                        children.add(new PathMetadata(prevStatus));
                    }
                    dirMeta = new DirListingMetadata(f, children, authoritative);
                    ms.put(dirMeta);
                }
                pathMetas.add(new PathMetadata(status));
                prevStatus = status;
            }
            ms.put(pathMetas);
        }
        catch (IOException ioe) {
            LOG.error("MetadataStore#put() failure:", (Throwable)ioe);
        }
    }

    public static void addMoveDir(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, Path dstPath, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcPath, dstPath);
        S3AFileStatus dstStatus = S3AUtils.createUploadFileStatus(dstPath, true, 0L, 0L, owner);
        S3Guard.addMoveStatus(srcPaths, dstMetas, srcPath, dstStatus);
    }

    public static void addMoveFile(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, Path dstPath, long size, long blockSize, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcPath, dstPath);
        S3AFileStatus dstStatus = S3AUtils.createUploadFileStatus(dstPath, false, size, blockSize, owner);
        S3Guard.addMoveStatus(srcPaths, dstMetas, srcPath, dstStatus);
    }

    public static void addMoveAncestors(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcRoot, Path srcPath, Path dstPath, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcRoot, srcPath, dstPath);
        if (srcPath.equals((Object)srcRoot)) {
            LOG.debug("Skip moving ancestors of source root directory {}", (Object)srcRoot);
            return;
        }
        Path parentSrc = srcPath.getParent();
        Path parentDst = dstPath.getParent();
        while (!(parentSrc == null || parentSrc.isRoot() || parentSrc.equals((Object)srcRoot) || srcPaths.contains(parentSrc))) {
            LOG.debug("Renaming non-listed parent {} to {}", (Object)parentSrc, (Object)parentDst);
            S3Guard.addMoveDir(ms, srcPaths, dstMetas, parentSrc, parentDst, owner);
            parentSrc = parentSrc.getParent();
            parentDst = parentDst.getParent();
        }
    }

    public static void addAncestors(MetadataStore metadataStore, Path qualifiedPath, String username) throws IOException {
        PathMetadata directory;
        ArrayList<PathMetadata> newDirs = new ArrayList<PathMetadata>();
        Path parent = qualifiedPath.getParent();
        while (!parent.isRoot() && ((directory = metadataStore.get(parent)) == null || directory.isDeleted())) {
            FileStatus status = new FileStatus(0L, true, 1, 0L, 0L, 0L, null, username, null, parent);
            PathMetadata meta = new PathMetadata(status, Tristate.FALSE, false);
            newDirs.add(meta);
            parent = parent.getParent();
        }
        metadataStore.put(newDirs);
    }

    private static void addMoveStatus(Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, FileStatus dstStatus) {
        srcPaths.add(srcPath);
        dstMetas.add(new PathMetadata(dstStatus));
    }

    public static void assertQualified(Path p) {
        URI uri = p.toUri();
        Preconditions.checkNotNull((Object)uri.getHost(), (Object)("Null host in " + uri));
        Preconditions.checkNotNull((Object)uri.getScheme(), (Object)("Null scheme in " + uri));
    }

    public static void assertQualified(Path ... paths) {
        for (Path path : paths) {
            S3Guard.assertQualified(path);
        }
    }
}

