/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextCreateMkdirBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.Assume;
import org.junit.BeforeClass;

public class TestAdlFileContextCreateMkdirLive
extends FileContextCreateMkdirBaseTest {
    private static final String KEY_FILE_SYSTEM = "test.fs.adl.name";

    @BeforeClass
    public static void skipTestCheck() {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }

    public void setUp() throws Exception {
        Configuration conf = AdlStorageConfiguration.getConfiguration();
        String fileSystem = conf.get(KEY_FILE_SYSTEM);
        if (fileSystem == null || fileSystem.trim().length() == 0) {
            throw new Exception("Default file system not configured.");
        }
        URI uri = new URI(fileSystem);
        FileSystem fs = AdlStorageConfiguration.createStorageConnector();
        fc = FileContext.getFileContext((AbstractFileSystem)new DelegateToFileSystem(uri, fs, conf, fs.getScheme(), false){}, (Configuration)conf);
        super.setUp();
    }

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper(UUID.randomUUID().toString());
    }
}

