/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageEvent;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestAzureFileSystemErrorConditions {
    private static final int ALL_THREE_FILE_SIZE = 1024;

    @Test
    public void testNoInitialize() throws Exception {
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        boolean passed = false;
        try {
            store.retrieveMetadata("foo");
            passed = true;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        Assert.assertFalse((String)"Doing an operation on the store should throw if not initalized.", (boolean)passed);
    }

    @Test
    public void testAccessUnauthorizedPublicContainer() throws Exception {
        Path noAccessPath = new Path("wasb://nonExistentContainer@hopefullyNonExistentAccount/someFile");
        NativeAzureFileSystem.suppressRetryPolicy();
        try {
            FileSystem.get((URI)noAccessPath.toUri(), (Configuration)new Configuration()).open(noAccessPath);
            Assert.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (AzureException ex) {
            Assert.assertTrue((String)("Unexpected message in exception " + (Object)((Object)ex)), (boolean)ex.getMessage().contains("Unable to access container nonExistentContainer in account hopefullyNonExistentAccount"));
        }
        finally {
            NativeAzureFileSystem.resumeRetryPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessContainerWithWrongVersion() throws Exception {
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        MockStorageInterface mockStorage = new MockStorageInterface();
        store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
        try (NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);){
            Configuration conf = new Configuration();
            AzureBlobStorageTestAccount.setMockAccountKey(conf);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("hdi_version", "2090-04-05");
            mockStorage.addPreExistingContainer(AzureBlobStorageTestAccount.getMockContainerUri(), metadata);
            boolean passed = false;
            try {
                fs.initialize(new URI("wasb://mockContainer@mockAccount.blob.core.windows.net/"), conf);
                fs.listStatus(new Path("/"));
                passed = true;
            }
            catch (AzureException ex) {
                Assert.assertTrue((String)("Unexpected exception message: " + (Object)((Object)ex)), (boolean)ex.getMessage().contains("unsupported version: 2090-04-05."));
            }
            Assert.assertFalse((String)"Should've thrown an exception because of the wrong version.", (boolean)passed);
        }
    }

    private void injectTransientError(NativeAzureFileSystem fs, final ConnectionRecognizer connectionRecognizer) {
        fs.getStore().addTestHookToOperationContext(new AzureNativeFileSystemStore.TestHookOperationContext(){

            public OperationContext modifyOperationContext(OperationContext original) {
                original.getSendingRequestEventHandler().addListener((StorageEvent)new TransientErrorInjector(connectionRecognizer));
                return original;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnDelete() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("DELETE");
                }
            });
            Path testFile = new Path("/a/b");
            Assert.assertTrue((boolean)fs.createNewFile(testFile));
            Assert.assertTrue((boolean)fs.rename(testFile, new Path("/x")));
        }
        finally {
            testAccount.cleanup();
        }
    }

    private void writeAllThreeFile(NativeAzureFileSystem fs, Path testFile) throws IOException {
        byte[] buffer = new byte[1024];
        Arrays.fill(buffer, (byte)3);
        FSDataOutputStream stream = fs.create(testFile);
        stream.write(buffer);
        stream.close();
    }

    private void readAllThreeFile(NativeAzureFileSystem fs, Path testFile) throws IOException {
        byte[] buffer = new byte[1024];
        FSDataInputStream inStream = fs.open(testFile);
        Assert.assertEquals((long)buffer.length, (long)inStream.read(buffer, 0, buffer.length));
        inStream.close();
        for (int i = 0; i < buffer.length; ++i) {
            Assert.assertEquals((long)3L, (long)buffer[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnCommitBlockList() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("PUT") && connection.getURL().getQuery().contains("blocklist");
                }
            });
            Path testFile = new Path("/a/b");
            this.writeAllThreeFile(fs, testFile);
            this.readAllThreeFile(fs, testFile);
        }
        finally {
            testAccount.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnRead() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            Path testFile = new Path("/a/b");
            this.writeAllThreeFile(fs, testFile);
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("GET");
                }
            });
            this.readAllThreeFile(fs, testFile);
        }
        finally {
            testAccount.cleanup();
        }
    }

    private class TransientErrorInjector
    extends StorageEvent<SendingRequestEvent> {
        final ConnectionRecognizer connectionRecognizer;
        private boolean injectedErrorOnce = false;

        public TransientErrorInjector(ConnectionRecognizer connectionRecognizer) {
            this.connectionRecognizer = connectionRecognizer;
        }

        public void eventOccurred(SendingRequestEvent eventArg) {
            HttpURLConnection connection = (HttpURLConnection)eventArg.getConnectionObject();
            if (!this.connectionRecognizer.isTargetConnection(connection)) {
                return;
            }
            if (!this.injectedErrorOnce) {
                connection.setReadTimeout(1);
                connection.disconnect();
                this.injectedErrorOnce = true;
            }
        }
    }

    private static interface ConnectionRecognizer {
        public boolean isTargetConnection(HttpURLConnection var1);
    }
}

