/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestReadAndSeekPageBlobAfterWrite {
    private static final Log LOG = LogFactory.getLog(TestReadAndSeekPageBlobAfterWrite.class);
    private FileSystem fs;
    private AzureBlobStorageTestAccount testAccount;
    private byte[] randomData;
    private static final int PAGE_SIZE = 512;
    private static final int PAGE_DATA_SIZE = 510;
    private static final int MAX_BYTES = 0x2000000;
    private static final int MAX_PAGES = 65536;
    private Random rand = new Random();
    private static final String KEY = "/pageBlobs/file.dat";
    private static final Path PATH = new Path("/pageBlobs/file.dat");

    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Before
    public void setUp() throws Exception {
        this.testAccount = this.createTestAccount();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Assert.assertEquals((long)0L, (long)0L);
        this.randomData = new byte[0x2000000];
        this.rand.nextBytes(this.randomData);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
            this.fs = null;
        }
    }

    @Test
    public void testIsPageBlobFileName() {
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        String[] a = KEY.split("/");
        String key2 = a[1] + "/";
        Assert.assertTrue((boolean)store.isPageBlobKey(key2));
    }

    @Test
    public void testReadAfterWriteRandomData() throws IOException {
        int[] dataSizes;
        int PDS = 510;
        for (int i : dataSizes = new int[]{0, 1, 2, 3, 509, 510, 511, 512, 513, 1019, 1020, 1021, 1022, 1023, 5099, 5100, 5101, 5102, 5103, 0x2000000}) {
            this.testReadAfterWriteRandomData(i);
        }
    }

    private void testReadAfterWriteRandomData(int size) throws IOException {
        this.writeRandomData(size);
        this.readRandomDataAndVerify(size);
    }

    private void readRandomDataAndVerify(int size) throws AzureException, IOException {
        byte[] b = new byte[size];
        FSDataInputStream stream = this.fs.open(PATH);
        int bytesRead = stream.read(b);
        stream.close();
        Assert.assertEquals((long)bytesRead, (long)size);
        Assert.assertTrue((boolean)this.comparePrefix(this.randomData, b, size));
    }

    private boolean comparePrefix(byte[] a, byte[] b, int size) {
        if (a.length < size || b.length < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void writeRandomData(int size) throws IOException {
        FSDataOutputStream output = this.fs.create(PATH);
        output.write(this.randomData, 0, size);
        output.close();
    }

    @Test
    public void testPageBlobSeekAndReadAfterWrite() throws IOException {
        this.writeRandomData(0x2000000);
        int recordSize = 100;
        byte[] b = new byte[recordSize];
        FSDataInputStream stream = this.fs.open(PATH);
        int seekPosition = 2810;
        stream.seek((long)seekPosition);
        int bytesRead = stream.read(b);
        this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
        seekPosition = 5370;
        stream.seek((long)seekPosition);
        recordSize = 1000;
        b = new byte[recordSize];
        bytesRead = stream.read(b);
        this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
        recordSize = 100;
        seekPosition = 0x2000000 - recordSize;
        stream.seek((long)seekPosition);
        b = new byte[recordSize];
        bytesRead = stream.read(b);
        this.verifyReadRandomData(b, bytesRead, seekPosition, recordSize);
        recordSize = 100;
        seekPosition = 0x2000000 - recordSize + 50;
        stream.seek((long)seekPosition);
        b = new byte[recordSize];
        bytesRead = stream.read(b);
        Assert.assertEquals((long)50L, (long)bytesRead);
        byte[] tail = Arrays.copyOfRange(this.randomData, seekPosition, this.randomData.length);
        Assert.assertTrue((boolean)this.comparePrefix(tail, b, 50));
    }

    private void verifyReadRandomData(byte[] b, int bytesRead, int seekPosition, int recordSize) {
        byte[] originalRecordData = Arrays.copyOfRange(this.randomData, seekPosition, seekPosition + recordSize + 1);
        Assert.assertEquals((long)recordSize, (long)bytesRead);
        Assert.assertTrue((boolean)this.comparePrefix(originalRecordData, b, recordSize));
    }

    @Test
    public void testManySmallWritesWithHFlush() throws IOException {
        this.writeAndReadOneFile(50, 100, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndReadOneFile(int numWrites, int recordLength, int syncInterval) throws IOException {
        int NUM_WRITES = numWrites;
        int RECORD_LENGTH = recordLength;
        int SYNC_INTERVAL = syncInterval;
        long MINIMUM_EXPECTED_TIME = 20L;
        LOG.info((Object)("Writing " + NUM_WRITES * RECORD_LENGTH + " bytes to " + PATH.getName()));
        FSDataOutputStream output = this.fs.create(PATH);
        int writesSinceHFlush = 0;
        try {
            output.flush();
            output.hflush();
            for (int i = 0; i < NUM_WRITES; ++i) {
                output.write(this.randomData, i * RECORD_LENGTH, RECORD_LENGTH);
                ++writesSinceHFlush;
                output.flush();
                if (i % SYNC_INTERVAL != 0) continue;
                long start = Time.monotonicNow();
                output.hflush();
                writesSinceHFlush = 0;
                long end = Time.monotonicNow();
                LOG.debug((Object)("hflush duration = " + (end - start) + " msec."));
                Assert.assertTrue((String)String.format("hflush duration of %d, less than minimum expected of %d", end - start, 20L), (end - start >= 20L ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            long start = Time.monotonicNow();
            output.close();
            long end = Time.monotonicNow();
            LOG.debug((Object)("close duration = " + (end - start) + " msec."));
            if (writesSinceHFlush > 0) {
                Assert.assertTrue((String)String.format("close duration with >= 1 pending write is %d, less than minimum expected of %d", end - start, 20L), (end - start >= 20L ? 1 : 0) != 0);
            }
            throw throwable;
        }
        long start = Time.monotonicNow();
        output.close();
        long end = Time.monotonicNow();
        LOG.debug((Object)("close duration = " + (end - start) + " msec."));
        if (writesSinceHFlush > 0) {
            Assert.assertTrue((String)String.format("close duration with >= 1 pending write is %d, less than minimum expected of %d", end - start, 20L), (end - start >= 20L ? 1 : 0) != 0);
        }
        FSDataInputStream stream = this.fs.open(PATH);
        int SIZE = NUM_WRITES * RECORD_LENGTH;
        byte[] b = new byte[SIZE];
        try {
            stream.seek(0L);
            stream.read(b, 0, SIZE);
            this.verifyReadRandomData(b, SIZE, 0, SIZE);
        }
        finally {
            stream.close();
        }
        this.fs.delete(PATH, false);
    }

    @Test
    public void testLargeFileStress() throws IOException {
        int numWrites = 32;
        int recordSize = 0x100000;
        int syncInterval = 10;
        int repetitions = 1;
        for (int i = 0; i < repetitions; ++i) {
            this.writeAndReadOneFile(numWrites, recordSize, syncInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFileSizeExtension() throws IOException {
        int writeSize = 0x100000;
        int numWrites = 129;
        int dataByte = 5;
        byte[] data = new byte[0x100000];
        Arrays.fill(data, (byte)5);
        try (FSDataOutputStream output = this.fs.create(PATH);){
            for (int i = 0; i < 129; ++i) {
                output.write(data);
                output.hflush();
                LOG.debug((Object)("total writes = " + (i + 1)));
            }
        }
        Assert.assertTrue((boolean)true);
        FileStatus[] status = this.fs.listStatus(PATH);
        Assert.assertTrue((status[0].getLen() == 0x8100000L ? 1 : 0) != 0);
        LOG.debug((Object)("Total bytes written to " + PATH + " = " + status[0].getLen()));
        this.fs.delete(PATH, false);
    }
}

