/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.storage.StorageException;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.BlobMaterialization;
import org.apache.hadoop.fs.azure.FileMetadata;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.PartialListing;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemMetricsSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public class NativeAzureFileSystem
extends FileSystem {
    private static final int USER_WX_PERMISION = 192;
    private static final String TRAILING_PERIOD_PLACEHOLDER = "[[.]]";
    private static final Pattern TRAILING_PERIOD_PLACEHOLDER_PATTERN = Pattern.compile("\\[\\[\\.\\]\\](?=$|/)");
    private static final Pattern TRAILING_PERIOD_PATTERN = Pattern.compile("\\.(?=$|/)");
    public static final Log LOG = LogFactory.getLog(NativeAzureFileSystem.class);
    static final String AZURE_BLOCK_SIZE_PROPERTY_NAME = "fs.azure.block.size";
    static final String AZURE_TEMP_EXPIRY_PROPERTY_NAME = "fs.azure.fsck.temp.expiry.seconds";
    private static final int AZURE_TEMP_EXPIRY_DEFAULT = 3600;
    static final String PATH_DELIMITER = "/";
    static final String AZURE_TEMP_FOLDER = "_$azuretmpfolder$";
    private static final int AZURE_LIST_ALL = -1;
    private static final int AZURE_UNBOUNDED_DEPTH = -1;
    private static final long MAX_AZURE_BLOCK_SIZE = 0x20000000L;
    private static final String AZURE_DEFAULT_GROUP_PROPERTY_NAME = "fs.azure.permissions.supergroup";
    static final String AZURE_DEFAULT_GROUP_DEFAULT = "supergroup";
    static final String AZURE_BLOCK_LOCATION_HOST_PROPERTY_NAME = "fs.azure.block.location.impersonatedhost";
    private static final String AZURE_BLOCK_LOCATION_HOST_DEFAULT = "localhost";
    static final String AZURE_RINGBUFFER_CAPACITY_PROPERTY_NAME = "fs.azure.ring.buffer.capacity";
    static final String AZURE_OUTPUT_STREAM_BUFFER_SIZE_PROPERTY_NAME = "fs.azure.output.stream.buffer.size";
    public static final String SKIP_AZURE_METRICS_PROPERTY_NAME = "fs.azure.skip.metrics";
    private URI uri;
    private NativeFileSystemStore store;
    private AzureNativeFileSystemStore actualStore;
    private Path workingDir;
    private long blockSize = 0x20000000L;
    private AzureFileSystemInstrumentation instrumentation;
    private String metricsSourceName;
    private boolean isClosed = false;
    private static boolean suppressRetryPolicy = false;
    private static AtomicInteger metricsSourceNameCounter = new AtomicInteger();

    public String getScheme() {
        return "wasb";
    }

    public NativeAzureFileSystem() {
    }

    public NativeAzureFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    @VisibleForTesting
    static void suppressRetryPolicy() {
        suppressRetryPolicy = true;
    }

    @VisibleForTesting
    static void resumeRetryPolicy() {
        suppressRetryPolicy = false;
    }

    @VisibleForTesting
    public static String newMetricsSourceName() {
        int number = metricsSourceNameCounter.incrementAndGet();
        String baseName = "AzureFileSystemMetrics";
        if (number == 1) {
            return "AzureFileSystemMetrics";
        }
        return "AzureFileSystemMetrics" + number;
    }

    private static boolean isWasbScheme(String scheme) {
        return scheme != null && (scheme.equalsIgnoreCase("asv") || scheme.equalsIgnoreCase("asvs") || scheme.equalsIgnoreCase("wasb") || scheme.equalsIgnoreCase("wasbs"));
    }

    private static URI reconstructAuthorityIfNeeded(URI uri, Configuration conf) {
        URI defaultUri;
        if (null == uri.getAuthority() && (defaultUri = FileSystem.getDefaultUri((Configuration)conf)) != null && NativeAzureFileSystem.isWasbScheme((String)defaultUri.getScheme())) {
            try {
                return new URI(uri.getScheme(), defaultUri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new Error("Bad URI construction", e);
            }
        }
        return uri;
    }

    protected void checkPath(Path path) {
        super.checkPath(new Path(NativeAzureFileSystem.reconstructAuthorityIfNeeded((URI)path.toUri(), (Configuration)this.getConf())));
    }

    public void initialize(URI uri, Configuration conf) throws IOException, IllegalArgumentException {
        if (null == (uri = NativeAzureFileSystem.reconstructAuthorityIfNeeded((URI)uri, (Configuration)conf)).getAuthority()) {
            String errMsg = String.format("Cannot initialize WASB file system, URI authority not recognized.", new Object[0]);
            throw new IllegalArgumentException(errMsg);
        }
        super.initialize(uri, conf);
        if (this.store == null) {
            this.store = this.createDefaultStore(conf);
        }
        this.instrumentation = new AzureFileSystemInstrumentation(conf);
        if (!conf.getBoolean("fs.azure.skip.metrics", false)) {
            AzureFileSystemMetricsSystem.fileSystemStarted();
            this.metricsSourceName = NativeAzureFileSystem.newMetricsSourceName();
            String sourceDesc = "Azure Storage Volume File System metrics";
            AzureFileSystemMetricsSystem.registerSource((String)this.metricsSourceName, (String)sourceDesc, (MetricsSource)this.instrumentation);
        }
        this.store.initialize(uri, conf, this.instrumentation);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", UserGroupInformation.getCurrentUser().getShortUserName()).makeQualified(this.getUri(), this.getWorkingDirectory());
        this.blockSize = conf.getLong("fs.azure.block.size", 0x20000000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NativeAzureFileSystem. Initializing.");
            LOG.debug((Object)("  blockSize  = " + conf.getLong("fs.azure.block.size", 0x20000000L)));
        }
    }

    private NativeFileSystemStore createDefaultStore(Configuration conf) {
        this.actualStore = new AzureNativeFileSystemStore();
        if (suppressRetryPolicy) {
            this.actualStore.suppressRetryPolicy();
        }
        return this.actualStore;
    }

    private static String encodeTrailingPeriod(String toEncode) {
        Matcher matcher = TRAILING_PERIOD_PATTERN.matcher(toEncode);
        return matcher.replaceAll("[[.]]");
    }

    private static String decodeTrailingPeriod(String toDecode) {
        Matcher matcher = TRAILING_PERIOD_PLACEHOLDER_PATTERN.matcher(toDecode);
        return matcher.replaceAll(".");
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        URI tmpUri = path.toUri();
        String pathUri = tmpUri.getPath();
        Path newPath = path;
        if ("".equals(pathUri)) {
            newPath = new Path(tmpUri.toString() + "/");
        }
        if (!newPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String key = null;
        key = newPath.toUri().getPath();
        key = NativeAzureFileSystem.removeTrailingSlash((String)key);
        if ((key = NativeAzureFileSystem.encodeTrailingPeriod((String)key)).length() == 1) {
            return key;
        }
        return key.substring(1);
    }

    private static String removeTrailingSlash(String key) {
        if (key.length() == 0 || key.length() == 1) {
            return key;
        }
        if (key.charAt(key.length() - 1) == '/') {
            return key.substring(0, key.length() - 1);
        }
        return key;
    }

    private static Path keyToPath(String key) {
        if (key.equals("/")) {
            return new Path("/");
        }
        return new Path("/" + NativeAzureFileSystem.decodeTrailingPeriod((String)key));
    }

    @VisibleForTesting
    public Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    @VisibleForTesting
    public AzureNativeFileSystemStore getStore() {
        return this.actualStore;
    }

    NativeFileSystemStore getStoreInterface() {
        return this.store;
    }

    public AzureFileSystemInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, overwrite, true, bufferSize, replication, blockSize, progress, (SelfRenewingLease)null);
    }

    public SelfRenewingLease acquireLease(Path path) throws AzureException {
        String fullKey = this.pathToKey(this.makeAbsolute(path));
        return this.getStore().acquireLease(fullKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = f.getParent();
        SelfRenewingLease lease = null;
        if (this.store.isAtomicRenameKey(this.pathToKey(f))) {
            try {
                lease = this.acquireLease(parent);
            }
            catch (AzureException e) {
                String errorCode = "";
                try {
                    StorageException e2 = (StorageException)e.getCause();
                    errorCode = e2.getErrorCode();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (errorCode.equals("BlobNotFound")) {
                    throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
                }
                LOG.warn((Object)("Got unexpected exception trying to get lease on " + this.pathToKey(parent) + ". " + e.getMessage()));
                throw e;
            }
        }
        if (!this.exists(parent)) {
            try {
                lease.free();
                throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to free lease because: " + e.getMessage()));
            }
            throw new FileNotFoundException("Cannot create file " + f.getName() + " because parent folder does not exist.");
        }
        FSDataOutputStream out = null;
        try {
            out = this.create(f, permission, overwrite, false, bufferSize, replication, blockSize, progress, lease);
        }
        catch (Throwable throwable) {
            try {
                if (lease == null) throw throwable;
                lease.free();
                throw throwable;
            }
            catch (Exception e) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
                String msg = "Unable to free lease on " + parent.toUri();
                LOG.error((Object)msg);
                throw new IOException(msg, e);
            }
        }
        try {
            if (lease == null) return out;
            lease.free();
            return out;
        }
        catch (Exception e) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            String msg = "Unable to free lease on " + parent.toUri();
            LOG.error((Object)msg);
            throw new IOException(msg, e);
        }
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        EnumSet<CreateFlag> createflags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        boolean overwrite = flags.containsAll(createflags);
        return this.createNonRecursive(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.createNonRecursive(f, FsPermission.getFileDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    private FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, boolean createParent, int bufferSize, short replication, long blockSize, Progressable progress, SelfRenewingLease parentFolderLease) throws IOException {
        DataOutputStream bufOutStream;
        Path parentFolder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating file: " + f.toString()));
        }
        if (this.containsColon(f)) {
            throw new IOException("Cannot create file " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        FileMetadata existingMetadata = this.store.retrieveMetadata(key);
        if (existingMetadata != null) {
            if (existingMetadata.isDir()) {
                throw new IOException("Cannot create file " + f + "; already exists as a directory.");
            }
            if (!overwrite) {
                throw new IOException("File already exists:" + f);
            }
        }
        if ((parentFolder = absolutePath.getParent()) != null && parentFolder.getParent() != null) {
            String parentKey = this.pathToKey(parentFolder);
            FileMetadata parentMetadata = this.store.retrieveMetadata(parentKey);
            if (parentMetadata != null && parentMetadata.isDir() && parentMetadata.getBlobMaterialization() == BlobMaterialization.Explicit) {
                this.store.updateFolderLastModifiedTime(parentKey, parentFolderLease);
            } else {
                Path firstExisting = parentFolder.getParent();
                FileMetadata metadata = this.store.retrieveMetadata(this.pathToKey(firstExisting));
                while (metadata == null) {
                    firstExisting = firstExisting.getParent();
                    metadata = this.store.retrieveMetadata(this.pathToKey(firstExisting));
                }
                this.mkdirs(parentFolder, metadata.getPermissionStatus().getPermission(), true);
            }
        }
        FsPermission masked = this.applyUMask(permission, UMaskApplyMode.NewFile);
        PermissionStatus permissionStatus = this.createPermissionStatus(masked);
        if (this.store.isPageBlobKey(key)) {
            bufOutStream = this.store.storefile(key, permissionStatus);
        } else {
            String keyEncoded = NativeAzureFileSystem.encodeKey((String)key);
            this.store.storeEmptyLinkFile(key, keyEncoded, permissionStatus);
            bufOutStream = new NativeAzureFsOutputStream(this, (OutputStream)this.store.storefile(keyEncoded, permissionStatus), key, keyEncoded);
        }
        FSDataOutputStream fsOut = new FSDataOutputStream((OutputStream)bufOutStream, this.statistics);
        this.instrumentation.fileCreated();
        return fsOut;
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.delete(f, recursive, false);
    }

    public boolean delete(Path f, boolean recursive, boolean skipParentFolderLastModifidedTimeUpdate) throws IOException {
        Path absolutePath;
        String key;
        FileMetadata metaFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting file: " + f.toString()));
        }
        if (null == (metaFile = this.store.retrieveMetadata(key = this.pathToKey(absolutePath = this.makeAbsolute(f))))) {
            return false;
        }
        if (!metaFile.isDir()) {
            Path parentPath = absolutePath.getParent();
            if (parentPath.getParent() != null) {
                String parentKey = this.pathToKey(parentPath);
                FileMetadata parentMetadata = this.store.retrieveMetadata(parentKey);
                if (!parentMetadata.isDir()) {
                    throw new AzureException("File " + f + " has a parent directory " + parentPath + " which is also a file. Can't resolve.");
                }
                if (parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found an implicit parent directory while trying to delete the file " + f + ". Creating the directory blob for it in " + parentKey + "."));
                    }
                    this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
                } else if (!skipParentFolderLastModifidedTimeUpdate) {
                    this.store.updateFolderLastModifiedTime(parentKey, null);
                }
            }
            this.store.delete(key);
            this.instrumentation.fileDeleted();
        } else {
            String parentKey;
            FileMetadata parentMetadata;
            Path parentPath = absolutePath.getParent();
            if (parentPath.getParent() != null && (parentMetadata = this.store.retrieveMetadata(parentKey = this.pathToKey(parentPath))).getBlobMaterialization() == BlobMaterialization.Implicit) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found an implicit parent directory while trying to delete the directory " + f + ". Creating the directory blob for it in " + parentKey + "."));
                }
                this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            String priorLastKey = null;
            PartialListing listing = this.store.listAll(key, -1, 1, priorLastKey);
            FileMetadata[] contents = listing.getFiles();
            if (!recursive && contents.length > 0) {
                throw new IOException("Non-recursive delete of non-empty directory " + f.toString());
            }
            for (FileMetadata p : contents) {
                String suffix = p.getKey().substring(p.getKey().lastIndexOf("/"));
                if (!p.isDir()) {
                    this.store.delete(key + suffix);
                    this.instrumentation.fileDeleted();
                    continue;
                }
                if (this.delete(new Path(f.toString() + suffix), true)) continue;
                return false;
            }
            this.store.delete(key);
            Path parent = absolutePath.getParent();
            if (parent != null && parent.getParent() != null) {
                String parentKey2 = this.pathToKey(parent);
                if (!skipParentFolderLastModifidedTimeUpdate) {
                    this.store.updateFolderLastModifiedTime(parentKey2, null);
                }
            }
            this.instrumentation.directoryDeleted();
        }
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path absolutePath;
        String key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the file status for " + f.toString()));
        }
        if ((key = this.pathToKey(absolutePath = this.makeAbsolute(f))).length() == 0) {
            return this.newDirectory(null, absolutePath);
        }
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            if (meta.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Path " + f.toString() + "is a folder."));
                }
                if (this.conditionalRedoFolderRename(f)) {
                    throw new FileNotFoundException(absolutePath + ": No such file or directory.");
                }
                return this.newDirectory(meta, absolutePath);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found the path: " + f.toString() + " as a file."));
            }
            return this.newFile(meta, absolutePath);
        }
        throw new FileNotFoundException(absolutePath + ": No such file or directory.");
    }

    private boolean conditionalRedoFolderRename(Path f) throws IOException {
        if (f.getName().equals("")) {
            return false;
        }
        Path absoluteRenamePendingFile = this.renamePendingFilePath(f);
        if (this.exists(absoluteRenamePendingFile)) {
            FolderRenamePending pending = new FolderRenamePending(absoluteRenamePendingFile, this);
            pending.redo();
            return true;
        }
        return false;
    }

    private Path renamePendingFilePath(Path f) {
        Path absPath = this.makeAbsolute(f);
        String key = this.pathToKey(absPath);
        key = key + "-RenamePending.json";
        return NativeAzureFileSystem.keyToPath((String)key);
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Listing status for " + f.toString()));
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            if (!meta.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found path as a file");
                }
                return new FileStatus[]{this.newFile(meta, absolutePath)};
            }
            String partialKey = null;
            PartialListing listing = this.store.list(key, -1, 1, partialKey);
            boolean renamed = this.conditionalRedoFolderRenames(listing);
            if (renamed) {
                listing = this.store.list(key, -1, 1, partialKey);
            }
            for (FileMetadata fileMetadata : listing.getFiles()) {
                Path subpath = NativeAzureFileSystem.keyToPath((String)fileMetadata.getKey());
                if (fileMetadata.isDir()) {
                    if (fileMetadata.getKey().equals("_$azuretmpfolder$")) continue;
                    status.add(this.newDirectory(fileMetadata, subpath));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found path as a directory with " + status.size() + " files in it."));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Did not find any metadata for path: " + key));
            }
            throw new FileNotFoundException("File" + f + " does not exist.");
        }
        return status.toArray(new FileStatus[0]);
    }

    private boolean conditionalRedoFolderRenames(PartialListing listing) throws IllegalArgumentException, IOException {
        boolean renamed = false;
        for (FileMetadata fileMetadata : listing.getFiles()) {
            Path subpath = NativeAzureFileSystem.keyToPath((String)fileMetadata.getKey());
            if (!this.isRenamePendingFile(subpath)) continue;
            FolderRenamePending pending = new FolderRenamePending(subpath, this);
            pending.redo();
            renamed = true;
        }
        return renamed;
    }

    private boolean isRenamePendingFile(Path path) {
        return path.toString().endsWith("-RenamePending.json");
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.blockSize, meta.getLastModified(), 0L, meta.getPermissionStatus().getPermission(), meta.getPermissionStatus().getUserName(), meta.getPermissionStatus().getGroupName(), path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(FileMetadata meta, Path path) {
        return new FileStatus(0L, true, 1, this.blockSize, meta == null ? 0L : meta.getLastModified(), 0L, meta == null ? FsPermission.getDefault() : meta.getPermissionStatus().getPermission(), meta == null ? "" : meta.getPermissionStatus().getUserName(), meta == null ? "" : meta.getPermissionStatus().getGroupName(), path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FsPermission applyUMask(FsPermission permission, UMaskApplyMode applyMode) {
        FsPermission newPermission = new FsPermission(permission);
        if (applyMode == UMaskApplyMode.NewFile || applyMode == UMaskApplyMode.NewDirectory) {
            newPermission = newPermission.applyUMask(FsPermission.getUMask((Configuration)this.getConf()));
        }
        return newPermission;
    }

    private PermissionStatus createPermissionStatus(FsPermission permission) throws IOException {
        return new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), this.getConf().get("fs.azure.permissions.supergroup", "supergroup"), permission);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirs(f, permission, false);
    }

    public boolean mkdirs(Path f, FsPermission permission, boolean noUmask) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating directory: " + f.toString()));
        }
        if (this.containsColon(f)) {
            throw new IOException("Cannot create directory " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        PermissionStatus permissionStatus = null;
        permissionStatus = noUmask ? this.createPermissionStatus(this.applyUMask(FsPermission.createImmutable((short)((short)(permission.toShort() | 0xC0))), UMaskApplyMode.NewDirectoryNoUmask)) : this.createPermissionStatus(this.applyUMask(permission, UMaskApplyMode.NewDirectory));
        ArrayList<String> keysToCreateAsFolder = new ArrayList<String>();
        ArrayList<String> keysToUpdateAsFolder = new ArrayList<String>();
        boolean childCreated = false;
        Path current = absolutePath;
        Path parent = current.getParent();
        while (parent != null) {
            String currentKey = this.pathToKey(current);
            FileMetadata currentMetadata = this.store.retrieveMetadata(currentKey);
            if (currentMetadata != null && !currentMetadata.isDir()) {
                throw new IOException("Cannot create directory " + f + " because " + current + " is an existing file.");
            }
            if (currentMetadata == null) {
                keysToCreateAsFolder.add(currentKey);
                childCreated = true;
            } else {
                if (childCreated) {
                    keysToUpdateAsFolder.add(currentKey);
                }
                childCreated = false;
            }
            current = parent;
            parent = current.getParent();
        }
        for (String currentKey : keysToCreateAsFolder) {
            this.store.storeEmptyFolder(currentKey, permissionStatus);
        }
        this.instrumentation.directoryCreated();
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path absolutePath;
        String key;
        FileMetadata meta;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening file: " + f.toString()));
        }
        if ((meta = this.store.retrieveMetadata(key = this.pathToKey(absolutePath = this.makeAbsolute(f)))) == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (meta.isDir()) {
            throw new FileNotFoundException(f.toString() + " is a directory not a file.");
        }
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeAzureFsInputStream(this, this.store.retrieve(key), key, meta.getLength()), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileMetadata srcMetadata;
        FolderRenamePending renamePending = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Moving " + src + " to " + dst));
        }
        if (this.containsColon(dst)) {
            throw new IOException("Cannot rename to file " + dst + " through WASB that has colons in the name");
        }
        String srcKey = this.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        Path absoluteDst = this.makeAbsolute(dst);
        String dstKey = this.pathToKey(absoluteDst);
        FileMetadata dstMetadata = this.store.retrieveMetadata(dstKey);
        if (dstMetadata != null && dstMetadata.isDir()) {
            dstKey = this.pathToKey(this.makeAbsolute(new Path(dst, src.getName())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Destination " + dst + " is a directory, adjusted the destination to be " + dstKey));
            }
        } else {
            if (dstMetadata != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Destination " + dst + " is an already existing file, failing the rename."));
                }
                return false;
            }
            FileMetadata parentOfDestMetadata = this.store.retrieveMetadata(this.pathToKey(absoluteDst.getParent()));
            if (parentOfDestMetadata == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Parent of the destination " + dst + " doesn't exist, failing the rename."));
                }
                return false;
            }
            if (!parentOfDestMetadata.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Parent of the destination " + dst + " is a file, failing the rename."));
                }
                return false;
            }
        }
        if ((srcMetadata = this.store.retrieveMetadata(srcKey)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Source " + src + " doesn't exist, failing the rename."));
            }
            return false;
        }
        if (!srcMetadata.isDir()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Source " + src + " found as a file, renaming."));
            }
        } else {
            renamePending = this.prepareAtomicFolderRename(srcKey, dstKey);
            renamePending.execute();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Renamed " + src + " to " + dst + " successfully."));
            }
            renamePending.cleanup();
            return true;
        }
        this.store.rename(srcKey, dstKey);
        this.updateParentFolderLastModifiedTime(srcKey);
        this.updateParentFolderLastModifiedTime(dstKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renamed " + src + " to " + dst + " successfully."));
        }
        return true;
    }

    private void updateParentFolderLastModifiedTime(String key) throws IOException {
        String parentKey;
        FileMetadata parentMetadata;
        Path parent = this.makeAbsolute(NativeAzureFileSystem.keyToPath((String)key)).getParent();
        if (parent != null && parent.getParent() != null && (parentMetadata = this.store.retrieveMetadata(parentKey = this.pathToKey(parent))) != null) {
            if (parentMetadata.isDir() && parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            if (this.store.isAtomicRenameKey(parentKey)) {
                SelfRenewingLease lease = null;
                try {
                    lease = this.leaseSourceFolder(parentKey);
                    this.store.updateFolderLastModifiedTime(parentKey, lease);
                }
                catch (AzureException e) {
                    String errorCode = "";
                    try {
                        StorageException e2 = (StorageException)e.getCause();
                        errorCode = e2.getErrorCode();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (errorCode.equals("BlobNotFound")) {
                        throw new FileNotFoundException("Folder does not exist: " + parentKey);
                    }
                    LOG.warn((Object)("Got unexpected exception trying to get lease on " + parentKey + ". " + e.getMessage()));
                    throw e;
                }
                finally {
                    try {
                        if (lease != null) {
                            lease.free();
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to free lease on " + parentKey), (Throwable)e);
                    }
                }
            }
            this.store.updateFolderLastModifiedTime(parentKey, null);
        }
    }

    private FolderRenamePending prepareAtomicFolderRename(String srcKey, String dstKey) throws IOException {
        if (this.store.isAtomicRenameKey(srcKey)) {
            SelfRenewingLease lease = this.leaseSourceFolder(srcKey);
            FolderRenamePending renamePending = new FolderRenamePending(srcKey, dstKey, lease, this);
            renamePending.writeFile((FileSystem)this);
            return renamePending;
        }
        FolderRenamePending renamePending = new FolderRenamePending(srcKey, dstKey, null, this);
        return renamePending;
    }

    private SelfRenewingLease leaseSourceFolder(String srcKey) throws AzureException {
        return this.store.acquireLease(srcKey);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String blobLocationHost = this.getConf().get("fs.azure.block.location.impersonatedhost", "localhost");
        String[] name = new String[]{blobLocationHost};
        String[] host = new String[]{blobLocationHost};
        long blockSize = file.getBlockSize();
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("The block size for the given file is not a positive number: " + blockSize);
        }
        int numberOfLocations = (int)(len / blockSize) + (len % blockSize == 0L ? 0 : 1);
        BlockLocation[] locations = new BlockLocation[numberOfLocations];
        for (int i = 0; i < locations.length; ++i) {
            long currentOffset = start + (long)i * blockSize;
            long currentLength = Math.min(blockSize, start + len - currentOffset);
            locations[i] = new BlockLocation(name, host, currentOffset, currentLength);
        }
        return locations;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = this.store.retrieveMetadata(key);
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        permission = this.applyUMask(permission, metadata.isDir() ? UMaskApplyMode.ChangeExistingDirectory : UMaskApplyMode.ChangeExistingFile);
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, this.createPermissionStatus(permission));
        } else if (!metadata.getPermissionStatus().getPermission().equals((Object)permission)) {
            this.store.changePermissionStatus(key, new PermissionStatus(metadata.getPermissionStatus().getUserName(), metadata.getPermissionStatus().getGroupName(), permission));
        }
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = this.store.retrieveMetadata(key);
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        PermissionStatus newPermissionStatus = new PermissionStatus(username == null ? metadata.getPermissionStatus().getUserName() : username, groupname == null ? metadata.getPermissionStatus().getGroupName() : groupname, metadata.getPermissionStatus().getPermission());
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, newPermissionStatus);
        } else {
            this.store.changePermissionStatus(key, newPermissionStatus);
        }
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        super.close();
        this.store.close();
        long startTime = System.currentTimeMillis();
        if (!this.getConf().getBoolean("fs.azure.skip.metrics", false)) {
            AzureFileSystemMetricsSystem.unregisterSource((String)this.metricsSourceName);
            AzureFileSystemMetricsSystem.fileSystemClosed();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting metrics when file system closed took " + (System.currentTimeMillis() - startTime) + " ms."));
        }
        this.isClosed = true;
    }

    private boolean containsColon(Path p) {
        return p.toUri().getPath().toString().contains(":");
    }

    private void handleFilesWithDanglingTempData(Path root, DanglingFileHandler handler) throws IOException {
        PartialListing listing;
        long cutoffForDangling = new Date().getTime() - (long)(this.getConf().getInt("fs.azure.fsck.temp.expiry.seconds", 3600) * 1000);
        String priorLastKey = null;
        do {
            listing = this.store.listAll(this.pathToKey(root), -1, -1, priorLastKey);
            for (FileMetadata file : listing.getFiles()) {
                FileMetadata linkMetadata;
                String link;
                if (file.isDir() || (link = this.store.getLinkInFileMetadata(file.getKey())) == null || (linkMetadata = this.store.retrieveMetadata(link)) == null || linkMetadata.getLastModified() < cutoffForDangling) continue;
                handler.handleFile(file, linkMetadata);
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
    }

    public void recoverFilesWithDanglingTempData(Path root, Path destination) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recovering files with dangling temp data in " + root));
        }
        this.handleFilesWithDanglingTempData(root, (DanglingFileHandler)new DanglingFileRecoverer(this, destination));
    }

    public void deleteFilesWithDanglingTempData(Path root) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting files with dangling temp data in " + root));
        }
        this.handleFilesWithDanglingTempData(root, (DanglingFileHandler)new DanglingFileDeleter(this, null));
    }

    protected void finalize() throws Throwable {
        LOG.debug((Object)"finalize() called.");
        this.close();
        super.finalize();
    }

    private static String encodeKey(String aKey) {
        String fileName = aKey.substring(aKey.lastIndexOf("/") + 1, aKey.length());
        String filePrefix = "_$azuretmpfolder$/" + UUID.randomUUID().toString();
        String randomizedKey = filePrefix + fileName;
        return randomizedKey;
    }

    static /* synthetic */ void access$000(NativeAzureFileSystem x0, String x1) throws IOException {
        x0.updateParentFolderLastModifiedTime(x1);
    }

    static /* synthetic */ Path access$100(String x0) {
        return NativeAzureFileSystem.keyToPath((String)x0);
    }

    static /* synthetic */ SelfRenewingLease access$200(NativeAzureFileSystem x0, String x1) throws AzureException {
        return x0.leaseSourceFolder(x1);
    }

    static /* synthetic */ NativeFileSystemStore access$300(NativeAzureFileSystem x0) {
        return x0.store;
    }

    static /* synthetic */ FileSystem.Statistics access$400(NativeAzureFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$500(NativeAzureFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$600(NativeAzureFileSystem x0) {
        return x0.statistics;
    }

    static /* synthetic */ FileSystem.Statistics access$700(NativeAzureFileSystem x0) {
        return x0.statistics;
    }
}

