/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.StorageInterface;

public class SelfRenewingLease {
    private StorageInterface.CloudBlobWrapper blobWrapper;
    private Thread renewer;
    private volatile boolean leaseFreed = false;
    private String leaseID = null;
    private static final int LEASE_TIMEOUT = 60;
    public static final int LEASE_RENEWAL_PERIOD = 40000;
    private static final Log LOG = LogFactory.getLog(SelfRenewingLease.class);
    private static AtomicInteger threadNumber = new AtomicInteger(0);
    private static final int LEASE_ACQUIRE_RETRY_INTERVAL = 2000;

    public SelfRenewingLease(StorageInterface.CloudBlobWrapper blobWrapper) throws StorageException {
        this.blobWrapper = blobWrapper;
        CloudBlob blob = blobWrapper.getBlob();
        while (this.leaseID == null) {
            block5: {
                try {
                    this.leaseID = blob.acquireLease(Integer.valueOf(60), null);
                }
                catch (StorageException e) {
                    if (e.getErrorCode().equals("LeaseAlreadyPresent")) break block5;
                    LOG.info((Object)("Caught exception when trying to get lease on blob " + blobWrapper.getUri().toString() + ". " + e.getMessage()));
                    throw e;
                }
            }
            if (this.leaseID != null) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.renewer = new Thread((Runnable)new Renewer(this, null));
        this.renewer.setDaemon(true);
        this.renewer.setName("AzureLeaseRenewer-" + threadNumber.getAndIncrement());
        this.renewer.start();
        LOG.debug((Object)("Acquired lease " + this.leaseID + " on " + blob.getUri() + " managed by thread " + this.renewer.getName()));
    }

    public void free() throws StorageException {
        block6: {
            AccessCondition accessCondition = AccessCondition.generateEmptyCondition();
            accessCondition.setLeaseID(this.leaseID);
            try {
                this.blobWrapper.getBlob().releaseLease(accessCondition);
            }
            catch (StorageException e) {
                if (e.getErrorCode().equals("BlobNotFound")) {
                    break block6;
                }
                LOG.warn((Object)("Unanticipated exception when trying to free lease " + this.leaseID + " on " + this.blobWrapper.getStorageUri()));
                throw e;
            }
            finally {
                this.leaseFreed = true;
                LOG.debug((Object)("Freed lease " + this.leaseID + " on " + this.blobWrapper.getUri() + " managed by thread " + this.renewer.getName()));
            }
        }
    }

    public boolean isFreed() {
        return this.leaseFreed;
    }

    public String getLeaseID() {
        return this.leaseID;
    }

    public CloudBlob getCloudBlob() {
        return this.blobWrapper.getBlob();
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ String access$200(SelfRenewingLease x0) {
        return x0.leaseID;
    }

    static /* synthetic */ boolean access$300(SelfRenewingLease x0) {
        return x0.leaseFreed;
    }

    static /* synthetic */ StorageInterface.CloudBlobWrapper access$400(SelfRenewingLease x0) {
        return x0.blobWrapper;
    }

    static /* synthetic */ boolean access$302(SelfRenewingLease x0, boolean x1) {
        x0.leaseFreed = x1;
        return x0.leaseFreed;
    }
}

