/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestNativeAzureFileSystemLive
extends NativeAzureFileSystemBaseTest {
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testIsPageBlobKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        Assert.assertEquals((Object)"pageBlobs", (Object)"pageBlobs");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/pageBlobs", "bar/pageBlobs/foo", "bar/pageBlobs/foo/", "/pageBlobs/", "/pageBlobs", "pageBlobs", "pageBlobsxyz/"}) {
            Assert.assertFalse((boolean)store.isPageBlobKey(s));
            Assert.assertFalse((boolean)store.isPageBlobKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"pageBlobs/", "pageBlobs/foo/", "pageBlobs/foo/bar/"}) {
            Assert.assertTrue((boolean)store.isPageBlobKey(s));
            Assert.assertTrue((boolean)store.isPageBlobKey(uriPrefix + s));
        }
    }

    @Test
    public void testIsAtomicRenameKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        Assert.assertEquals((Object)"/atomicRenameDir1,/atomicRenameDir2", (Object)"/atomicRenameDir1,/atomicRenameDir2");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/hbase", "bar/hbase/foo", "bar/hbase/foo/", "/hbase/", "/hbase", "hbase", "hbasexyz/", "foo/atomicRenameDir1/"}) {
            Assert.assertFalse((boolean)store.isAtomicRenameKey(s));
            Assert.assertFalse((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"hbase/", "hbase/foo/", "hbase/foo/bar/", "atomicRenameDir1/foo/", "atomicRenameDir2/bar/"}) {
            Assert.assertTrue((boolean)store.isAtomicRenameKey(s));
            Assert.assertTrue((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
    }
}

