/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestNativeAzureFileSystemMetricsSystem {
    private static final String WASB_FILES_CREATED = "wasb_files_created";

    private static int getFilesCreated(AzureBlobStorageTestAccount testAccount) {
        return testAccount.getLatestMetricValue("wasb_files_created", (Number)0).intValue();
    }

    @Test
    public void testMetricsAcrossFileSystems() throws Exception {
        AzureBlobStorageTestAccount a1 = AzureBlobStorageTestAccount.createMock();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a1));
        AzureBlobStorageTestAccount a2 = AzureBlobStorageTestAccount.createMock();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a2));
        a1.getFileSystem().create(new Path("/foo")).close();
        a1.getFileSystem().create(new Path("/bar")).close();
        a2.getFileSystem().create(new Path("/baz")).close();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a1));
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a2));
        a1.closeFileSystem();
        a2.closeFileSystem();
        Assert.assertEquals((long)2L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a1));
        Assert.assertEquals((long)1L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a2));
        AzureBlobStorageTestAccount a3 = AzureBlobStorageTestAccount.createMock();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a3));
        a3.closeFileSystem();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a3));
    }

    @Test
    public void testMetricsSourceNames() {
        String name1 = NativeAzureFileSystem.newMetricsSourceName();
        String name2 = NativeAzureFileSystem.newMetricsSourceName();
        Assert.assertTrue((boolean)name1.startsWith("AzureFileSystemMetrics"));
        Assert.assertTrue((boolean)name2.startsWith("AzureFileSystemMetrics"));
        Assert.assertTrue((!name1.equals(name2) ? 1 : 0) != 0);
    }

    @Test
    public void testSkipMetricsCollection() throws Exception {
        AzureBlobStorageTestAccount a = AzureBlobStorageTestAccount.createMock();
        a.getFileSystem().getConf().setBoolean("fs.azure.skip.metrics", true);
        a.getFileSystem().create(new Path("/foo")).close();
        a.closeFileSystem();
        Assert.assertEquals((long)0L, (long)TestNativeAzureFileSystemMetricsSystem.getFilesCreated((AzureBlobStorageTestAccount)a));
    }
}

