/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestNativeAzureFileSystemConcurrency {
    private AzureBlobStorageTestAccount testAccount;
    private FileSystem fs;
    private InMemoryBlockBlobStore backingStore;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        this.fs = this.testAccount.getFileSystem();
        this.backingStore = this.testAccount.getMockStorage().getBackingStore();
    }

    @After
    public void tearDown() throws Exception {
        this.testAccount.cleanup();
        this.fs = null;
        this.backingStore = null;
    }

    @Test
    public void testLinkBlobs() throws Exception {
        Path filePath = new Path("/inProgress");
        FSDataOutputStream outputStream = this.fs.create(filePath);
        HashMap metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri((Path)filePath));
        Assert.assertNotNull((Object)metadata);
        String linkValue = (String)metadata.get("hdi_tmpupload");
        linkValue = URLDecoder.decode(linkValue, "UTF-8");
        Assert.assertNotNull((Object)linkValue);
        Assert.assertTrue((boolean)this.backingStore.exists(AzureBlobStorageTestAccount.toMockUri((String)linkValue)));
        Assert.assertTrue((boolean)this.fs.exists(filePath));
        outputStream.close();
        metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri((Path)filePath));
        Assert.assertNull(metadata.get("hdi_tmpupload"));
    }

    private static String toString(FileStatus[] list) {
        String[] asStrings = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            asStrings[i] = list[i].getPath().toString();
        }
        return StringUtils.join((CharSequence)",", (String[])asStrings);
    }

    @Test
    public void testNoTempBlobsVisible() throws Exception {
        Path filePath = new Path("/inProgress");
        FSDataOutputStream outputStream = this.fs.create(filePath);
        FileStatus[] listOfRoot = this.fs.listStatus(new Path("/"));
        Assert.assertEquals((String)("Expected one file listed, instead got: " + TestNativeAzureFileSystemConcurrency.toString((FileStatus[])listOfRoot)), (long)1L, (long)listOfRoot.length);
        Assert.assertEquals((Object)this.fs.makeQualified(filePath), (Object)listOfRoot[0].getPath());
        outputStream.close();
    }

    private static Iterable<String> selectToString(Iterable<Throwable> collection) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void testMultiThreadedOperation() throws Exception {
        for (int iter = 0; iter < 10; ++iter) {
            int numThreads = 20;
            Thread[] threads = new Thread[20];
            ConcurrentLinkedQueue exceptionsEncountered = new ConcurrentLinkedQueue();
            for (int i = 0; i < 20; ++i) {
                Path threadLocalFile = new Path("/myFile" + i);
                threads[i] = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertTrue((String)("Encountered exceptions: " + StringUtils.join((CharSequence)"\r\n", (Iterable)TestNativeAzureFileSystemConcurrency.selectToString(exceptionsEncountered))), (boolean)exceptionsEncountered.isEmpty());
            this.tearDown();
            this.setUp();
        }
    }

    static /* synthetic */ FileSystem access$000(TestNativeAzureFileSystemConcurrency x0) {
        return x0.fs;
    }
}

