/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureMetricsTestUtil;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;
import org.junit.Assert;
import org.junit.Test;

public class TestBandwidthGaugeUpdater {
    @Test
    public void testSingleThreaded() throws Exception {
        AzureFileSystemInstrumentation instrumentation = new AzureFileSystemInstrumentation(new Configuration());
        BandwidthGaugeUpdater updater = new BandwidthGaugeUpdater(instrumentation, 1000, true);
        updater.triggerUpdate(true);
        Assert.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)instrumentation));
        updater.blockUploaded(new Date(), new Date(), 150L);
        updater.triggerUpdate(true);
        Assert.assertEquals((long)150L, (long)AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)instrumentation));
        updater.blockUploaded(new Date(new Date().getTime() - 10000L), new Date(), 200L);
        updater.triggerUpdate(true);
        long currentBytes = AzureMetricsTestUtil.getCurrentBytesWritten((AzureFileSystemInstrumentation)instrumentation);
        Assert.assertTrue((String)("We expect around (200/10 = 20) bytes written as the gauge value.Got " + currentBytes), (currentBytes > 18L && currentBytes < 22L ? 1 : 0) != 0);
        updater.close();
    }

    @Test
    public void testMultiThreaded() throws Exception {
        AzureFileSystemInstrumentation instrumentation = new AzureFileSystemInstrumentation(new Configuration());
        BandwidthGaugeUpdater updater = new BandwidthGaugeUpdater(instrumentation, 1000, true);
        Thread[] threads = new Thread[10];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        updater.triggerUpdate(false);
        Assert.assertEquals((long)(10 * threads.length), (long)AzureMetricsTestUtil.getCurrentBytesRead((AzureFileSystemInstrumentation)instrumentation));
        updater.close();
    }
}

