/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimeZone;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.StorageInterface;

public class MockStorageInterface
extends StorageInterface {
    private InMemoryBlockBlobStore backingStore;
    private final ArrayList<PreExistingContainer> preExistingContainers = new ArrayList();
    private String baseUriString;

    public InMemoryBlockBlobStore getBackingStore() {
        return this.backingStore;
    }

    public void addPreExistingContainer(String uri, HashMap<String, String> metadata) {
        this.preExistingContainers.add(new PreExistingContainer(uri, metadata));
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
    }

    public void setTimeoutInMs(int timeoutInMs) {
    }

    public void createBlobClient(CloudStorageAccount account) {
        this.backingStore = new InMemoryBlockBlobStore();
    }

    public void createBlobClient(URI baseUri) {
        this.backingStore = new InMemoryBlockBlobStore();
    }

    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        this.baseUriString = baseUri.toString();
        this.backingStore = new InMemoryBlockBlobStore();
    }

    public StorageCredentials getCredentials() {
        return null;
    }

    private static String convertUriToDecodedString(URI uri) {
        try {
            String result = URIUtil.decode((String)uri.toString());
            return result;
        }
        catch (URIException e) {
            throw new AssertionError((Object)("Failed to decode URI: " + uri.toString()));
        }
    }

    private static URI convertKeyToEncodedUri(String key) {
        try {
            String encodedKey = URIUtil.encodePath((String)key);
            URI uri = new URI(encodedKey);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)("Failed to encode key: " + key));
        }
        catch (URIException e) {
            throw new AssertionError((Object)("Failed to encode key: " + key));
        }
    }

    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String name) throws URISyntaxException, StorageException {
        String fullUri;
        try {
            fullUri = this.baseUriString + "/" + URIUtil.encodePath((String)name);
        }
        catch (URIException e) {
            throw new RuntimeException("problem encoding fullUri", e);
        }
        MockCloudBlobContainerWrapper container = new MockCloudBlobContainerWrapper(fullUri, name);
        for (PreExistingContainer existing : this.preExistingContainers) {
            if (!fullUri.equalsIgnoreCase(existing.containerUri)) continue;
            container.created = true;
            this.backingStore.setContainerMetadata(existing.containerMetadata);
            break;
        }
        return container;
    }

    class MockCloudPageBlobWrapper
    extends MockCloudBlobWrapper
    implements StorageInterface.CloudPageBlobWrapper {
        public MockCloudPageBlobWrapper(URI uri, HashMap<String, String> metadata, int length) {
            super(uri, metadata, length);
        }

        public void create(long length, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            throw new NotImplementedException();
        }

        public void uploadPages(InputStream sourceStream, long offset, long length, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            throw new NotImplementedException();
        }

        public ArrayList<PageRange> downloadPageRanges(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            throw new NotImplementedException();
        }

        public void setStreamMinimumReadSizeInBytes(int minimumReadSize) {
        }

        public void setWriteBlockSizeInBytes(int writeBlockSizeInBytes) {
        }

        public StorageUri getStorageUri() {
            throw new NotImplementedException();
        }

        public void uploadProperties(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
        }

        public SelfRenewingLease acquireLease() {
            return null;
        }

        public CloudBlob getBlob() {
            return null;
        }
    }

    class MockCloudBlockBlobWrapper
    extends MockCloudBlobWrapper
    implements StorageInterface.CloudBlockBlobWrapper {
        public MockCloudBlockBlobWrapper(URI uri, HashMap<String, String> metadata, int length) {
            super(uri, metadata, length);
        }

        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return MockStorageInterface.this.backingStore.uploadBlockBlob(MockStorageInterface.convertUriToDecodedString(this.uri), this.metadata);
        }

        public void setStreamMinimumReadSizeInBytes(int minimumReadSizeBytes) {
        }

        public void setWriteBlockSizeInBytes(int writeBlockSizeBytes) {
        }

        public StorageUri getStorageUri() {
            return null;
        }

        public void uploadProperties(OperationContext context, SelfRenewingLease lease) {
        }

        public SelfRenewingLease acquireLease() {
            return null;
        }

        public CloudBlob getBlob() {
            return null;
        }
    }

    abstract class MockCloudBlobWrapper
    implements StorageInterface.CloudBlobWrapper {
        protected final URI uri;
        protected HashMap<String, String> metadata = new HashMap();
        protected BlobProperties properties;

        protected MockCloudBlobWrapper(URI uri, HashMap<String, String> metadata, int length) {
            this.uri = uri;
            this.metadata = metadata;
            this.properties = new BlobProperties();
            this.properties = this.updateLastModifed(this.properties);
            this.properties = this.updateLength(this.properties, length);
        }

        protected BlobProperties updateLastModifed(BlobProperties properties) {
            try {
                Method setLastModified = properties.getClass().getDeclaredMethod("setLastModified", Date.class);
                setLastModified.setAccessible(true);
                setLastModified.invoke((Object)this.properties, Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return properties;
        }

        protected BlobProperties updateLength(BlobProperties properties, int length) {
            try {
                Method setLength = properties.getClass().getDeclaredMethod("setLength", Long.TYPE);
                setLength.setAccessible(true);
                setLength.invoke((Object)this.properties, length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return properties;
        }

        protected void refreshProperties(boolean getMetadata) {
            if (MockStorageInterface.this.backingStore.exists(MockStorageInterface.convertUriToDecodedString(this.uri))) {
                byte[] content = MockStorageInterface.this.backingStore.getContent(MockStorageInterface.convertUriToDecodedString(this.uri));
                this.properties = new BlobProperties();
                this.properties = this.updateLastModifed(this.properties);
                this.properties = this.updateLength(this.properties, content.length);
                if (getMetadata) {
                    this.metadata = MockStorageInterface.this.backingStore.getMetadata(MockStorageInterface.convertUriToDecodedString(this.uri));
                }
            }
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return null;
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return null;
        }

        public URI getUri() {
            return this.uri;
        }

        public HashMap<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(HashMap<String, String> metadata) {
            this.metadata = metadata;
        }

        public void startCopyFromBlob(URI source, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
            MockStorageInterface.this.backingStore.copy(MockStorageInterface.convertUriToDecodedString(source), MockStorageInterface.convertUriToDecodedString(this.uri));
        }

        public CopyState getCopyState() {
            return this.properties.getCopyState();
        }

        public void delete(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            MockStorageInterface.this.backingStore.delete(MockStorageInterface.convertUriToDecodedString(this.uri));
        }

        public boolean exists(OperationContext opContext) throws StorageException {
            return MockStorageInterface.this.backingStore.exists(MockStorageInterface.convertUriToDecodedString(this.uri));
        }

        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.refreshProperties(true);
        }

        public BlobProperties getProperties() {
            return this.properties;
        }

        public InputStream openInputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return new ByteArrayInputStream(MockStorageInterface.this.backingStore.getContent(MockStorageInterface.convertUriToDecodedString(this.uri)));
        }

        public void uploadMetadata(OperationContext opContext) throws StorageException {
            MockStorageInterface.this.backingStore.setMetadata(MockStorageInterface.convertUriToDecodedString(this.uri), this.metadata);
        }

        public void downloadRange(long offset, long length, OutputStream os, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            throw new NotImplementedException();
        }
    }

    class MockCloudBlobDirectoryWrapper
    extends StorageInterface.CloudBlobDirectoryWrapper {
        private URI uri;

        public MockCloudBlobDirectoryWrapper(URI uri) {
            this.uri = uri;
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return null;
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return null;
        }

        public URI getUri() {
            return this.uri;
        }

        public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
            ArrayList<ListBlobItem> ret = new ArrayList<ListBlobItem>();
            URI searchUri = null;
            if (prefix == null) {
                searchUri = this.uri;
            } else {
                try {
                    searchUri = UriBuilder.fromUri((URI)this.uri).path(prefix).build(new Object[0]);
                }
                catch (UriBuilderException e) {
                    throw new AssertionError((Object)("Failed to encode path: " + prefix));
                }
            }
            String fullPrefix = MockStorageInterface.convertUriToDecodedString(searchUri);
            boolean includeMetadata = listingDetails.contains(BlobListingDetails.METADATA);
            HashSet<String> addedDirectories = new HashSet<String>();
            for (InMemoryBlockBlobStore.ListBlobEntry current : MockStorageInterface.this.backingStore.listBlobs(fullPrefix, includeMetadata)) {
                int indexOfSlash = current.getKey().indexOf(47, fullPrefix.length());
                if (useFlatBlobListing || indexOfSlash < 0) {
                    if (current.isPageBlob()) {
                        ret.add((ListBlobItem)new MockCloudPageBlobWrapper(MockStorageInterface.convertKeyToEncodedUri(current.getKey()), current.getMetadata(), current.getContentLength()));
                        continue;
                    }
                    ret.add((ListBlobItem)new MockCloudBlockBlobWrapper(MockStorageInterface.convertKeyToEncodedUri(current.getKey()), current.getMetadata(), current.getContentLength()));
                    continue;
                }
                String directoryName = current.getKey().substring(0, indexOfSlash);
                if (addedDirectories.contains(directoryName)) continue;
                addedDirectories.add(current.getKey());
                ret.add((ListBlobItem)new MockCloudBlobDirectoryWrapper(new URI(directoryName + "/")));
            }
            return ret;
        }

        public StorageUri getStorageUri() {
            throw new NotImplementedException();
        }
    }

    private static class PreExistingContainer {
        final String containerUri;
        final HashMap<String, String> containerMetadata;

        public PreExistingContainer(String uri, HashMap<String, String> metadata) {
            this.containerUri = uri;
            this.containerMetadata = metadata;
        }
    }

    class MockCloudBlobContainerWrapper
    extends StorageInterface.CloudBlobContainerWrapper {
        private boolean created = false;
        private HashMap<String, String> metadata;
        private final String baseUri;
        private final String name;

        public MockCloudBlobContainerWrapper(String baseUri, String name) {
            this.baseUri = baseUri;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists(OperationContext opContext) throws StorageException {
            return this.created;
        }

        public void create(OperationContext opContext) throws StorageException {
            this.created = true;
            MockStorageInterface.this.backingStore.setContainerMetadata(this.metadata);
        }

        public HashMap<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(HashMap<String, String> metadata) {
            this.metadata = metadata;
        }

        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.metadata = MockStorageInterface.this.backingStore.getContainerMetadata();
        }

        public void uploadMetadata(OperationContext opContext) throws StorageException {
            MockStorageInterface.this.backingStore.setContainerMetadata(this.metadata);
        }

        public StorageInterface.CloudBlobDirectoryWrapper getDirectoryReference(String relativePath) throws URISyntaxException, StorageException {
            return new MockCloudBlobDirectoryWrapper(new URI(this.fullUriString(relativePath, true)));
        }

        public StorageInterface.CloudBlockBlobWrapper getBlockBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new MockCloudBlockBlobWrapper(new URI(this.fullUriString(relativePath, false)), null, 0);
        }

        public StorageInterface.CloudPageBlobWrapper getPageBlobReference(String blobAddressUri) throws URISyntaxException, StorageException {
            return new MockCloudPageBlobWrapper(new URI(blobAddressUri), null, 0);
        }

        private String fullUriString(String relativePath, boolean withTrailingSlash) {
            String fullUri;
            String baseUri = this.baseUri;
            if (!baseUri.endsWith("/")) {
                baseUri = baseUri + "/";
            }
            if (withTrailingSlash && !relativePath.equals("") && !relativePath.endsWith("/")) {
                relativePath = relativePath + "/";
            }
            try {
                fullUri = baseUri + URIUtil.encodePath((String)relativePath);
            }
            catch (URIException e) {
                throw new RuntimeException("problem encoding fullUri", e);
            }
            return fullUri;
        }
    }
}

