/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ResponseReceivedEvent;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockSearchMode;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.core.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestBlobDataValidation {
    private AzureBlobStorageTestAccount testAccount;

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
        }
    }

    @Test
    public void testBlobMd5StoreOffByDefault() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        this.testStoreBlobMd5(false);
    }

    @Test
    public void testStoreBlobMd5() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.azure.store.blob.md5", true);
        this.testAccount = AzureBlobStorageTestAccount.create(conf);
        this.testStoreBlobMd5(true);
    }

    private void testStoreBlobMd5(boolean expectMd5Stored) throws Exception {
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        String testFileKey = "testFile";
        Path testFilePath = new Path("/" + testFileKey);
        FSDataOutputStream outStream = this.testAccount.getFileSystem().create(testFilePath);
        outStream.write(new byte[]{5, 15});
        outStream.close();
        CloudBlockBlob blob = this.testAccount.getBlobReference(testFileKey);
        blob.downloadAttributes();
        String obtainedMd5 = blob.getProperties().getContentMD5();
        if (expectMd5Stored) {
            Assert.assertNotNull((Object)obtainedMd5);
        } else {
            Assert.assertNull((String)("Expected no MD5, found: " + obtainedMd5), (Object)obtainedMd5);
        }
        String newBlockId = Base64.encode((byte[])new byte[]{55, 44, 33, 22});
        blob.uploadBlock(newBlockId, (InputStream)new ByteArrayInputStream(new byte[]{6, 45}), 2L);
        blob.commitBlockList(Arrays.asList(new BlockEntry(newBlockId, BlockSearchMode.UNCOMMITTED)));
        FSDataInputStream inStream = this.testAccount.getFileSystem().open(testFilePath);
        try {
            byte[] inBuf = new byte[100];
            while (inStream.read(inBuf) > 0) {
            }
            inStream.close();
            if (expectMd5Stored) {
                Assert.fail((String)"Should've thrown because of data corruption.");
            }
        }
        catch (IOException ex) {
            if (!expectMd5Stored) {
                throw ex;
            }
            StorageException cause = (StorageException)ex.getCause();
            Assert.assertNotNull((Object)((Object)cause));
            Assert.assertTrue((String)("Unexpected cause: " + (Object)((Object)cause)), (boolean)cause.getErrorCode().equals("InvalidMd5"));
        }
    }

    @Test
    public void testCheckBlockMd5() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.create();
        this.testCheckBlockMd5(true);
    }

    @Test
    public void testDontCheckBlockMd5() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.azure.check.block.md5", false);
        this.testAccount = AzureBlobStorageTestAccount.create(conf);
        this.testCheckBlockMd5(false);
    }

    private void testCheckBlockMd5(final boolean expectMd5Checked) throws Exception {
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        Path testFilePath = new Path("/testFile");
        this.testAccount.getFileSystem().getStore().addTestHookToOperationContext(new AzureNativeFileSystemStore.TestHookOperationContext(){

            public OperationContext modifyOperationContext(OperationContext original) {
                original.getResponseReceivedEventHandler().addListener((StorageEvent)new ContentMD5Checker(expectMd5Checked));
                return original;
            }
        });
        FSDataOutputStream outStream = this.testAccount.getFileSystem().create(testFilePath);
        outStream.write(new byte[]{5, 15});
        outStream.close();
        FSDataInputStream inStream = this.testAccount.getFileSystem().open(testFilePath);
        byte[] inBuf = new byte[100];
        while (inStream.read(inBuf) > 0) {
        }
        inStream.close();
    }

    private static class ContentMD5Checker
    extends StorageEvent<ResponseReceivedEvent> {
        private final boolean expectMd5;

        public ContentMD5Checker(boolean expectMd5) {
            this.expectMd5 = expectMd5;
        }

        public void eventOccurred(ResponseReceivedEvent eventArg) {
            HttpURLConnection connection = (HttpURLConnection)eventArg.getConnectionObject();
            if (ContentMD5Checker.isGetRange(connection)) {
                this.checkObtainedMd5(connection.getHeaderField("Content-MD5"));
            } else if (ContentMD5Checker.isPutBlock(connection)) {
                this.checkObtainedMd5(connection.getRequestProperty("Content-MD5"));
            }
        }

        private void checkObtainedMd5(String obtainedMd5) {
            if (this.expectMd5) {
                Assert.assertNotNull((Object)obtainedMd5);
            } else {
                Assert.assertNull((String)("Expected no MD5, found: " + obtainedMd5), (Object)obtainedMd5);
            }
        }

        private static boolean isPutBlock(HttpURLConnection connection) {
            return connection.getRequestMethod().equals("PUT") && connection.getURL().getQuery().contains("blockid");
        }

        private static boolean isGetRange(HttpURLConnection connection) {
            return connection.getRequestMethod().equals("GET") && connection.getHeaderField("x-ms-range") != null;
        }
    }
}

