/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBlobMetadata {
    private AzureBlobStorageTestAccount testAccount;
    private FileSystem fs;
    private InMemoryBlockBlobStore backingStore;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        this.fs = this.testAccount.getFileSystem();
        this.backingStore = this.testAccount.getMockStorage().getBackingStore();
    }

    @After
    public void tearDown() throws Exception {
        this.testAccount.cleanup();
        this.fs = null;
        this.backingStore = null;
    }

    private static String getExpectedOwner() throws Exception {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    private static String getExpectedPermissionString(String permissionString) throws Exception {
        return String.format("{\"owner\":\"%s\",\"group\":\"%s\",\"permissions\":\"%s\"}", TestBlobMetadata.getExpectedOwner(), "supergroup", permissionString);
    }

    @Test
    public void testContainerVersionMetadata() throws Exception {
        this.fs.createNewFile(new Path("/foo"));
        HashMap<String, String> containerMetadata = this.backingStore.getContainerMetadata();
        Assert.assertNotNull(containerMetadata);
        Assert.assertEquals((Object)"2013-09-01", (Object)containerMetadata.get("hdi_version"));
    }

    @Test
    public void testPreExistingContainerVersionMetadata() throws Exception {
        FsWithPreExistingContainer fsWithContainer = FsWithPreExistingContainer.create();
        Assert.assertFalse((boolean)fsWithContainer.getFs().exists(new Path("/IDontExist")));
        Assert.assertEquals((long)0L, (long)fsWithContainer.getFs().listStatus(new Path("/")).length);
        Assert.assertNull(fsWithContainer.getContainerMetadata());
        fsWithContainer.getFs().mkdirs(new Path("/dir"));
        Assert.assertNotNull(fsWithContainer.getContainerMetadata());
        Assert.assertEquals((Object)"2013-09-01", (Object)fsWithContainer.getContainerMetadata().get("hdi_version"));
        fsWithContainer.close();
    }

    @Test
    public void testFirstContainerVersionMetadata() throws Exception {
        HashMap<String, String> containerMetadata = new HashMap<String, String>();
        containerMetadata.put("asv_version", "2013-01-01");
        FsWithPreExistingContainer fsWithContainer = FsWithPreExistingContainer.create(containerMetadata);
        Assert.assertFalse((boolean)fsWithContainer.getFs().exists(new Path("/IDontExist")));
        Assert.assertEquals((long)0L, (long)fsWithContainer.getFs().listStatus(new Path("/")).length);
        Assert.assertEquals((Object)"2013-01-01", (Object)fsWithContainer.getContainerMetadata().get("asv_version"));
        Assert.assertNull((Object)fsWithContainer.getContainerMetadata().get("hdi_version"));
        fsWithContainer.getFs().mkdirs(new Path("/dir"));
        Assert.assertEquals((Object)"2013-09-01", (Object)fsWithContainer.getContainerMetadata().get("hdi_version"));
        Assert.assertNull((Object)fsWithContainer.getContainerMetadata().get("asv_version"));
        fsWithContainer.close();
    }

    @Test
    public void testPermissionMetadata() throws Exception {
        FsPermission justMe = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        Path selfishFile = new Path("/noOneElse");
        this.fs.create(selfishFile, justMe, true, 4096, this.fs.getDefaultReplication(), this.fs.getDefaultBlockSize(), null).close();
        HashMap<String, String> metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri(selfishFile));
        Assert.assertNotNull(metadata);
        String storedPermission = metadata.get("hdi_permission");
        Assert.assertEquals((Object)TestBlobMetadata.getExpectedPermissionString("rw-------"), (Object)storedPermission);
        FileStatus retrievedStatus = this.fs.getFileStatus(selfishFile);
        Assert.assertNotNull((Object)retrievedStatus);
        Assert.assertEquals((Object)justMe, (Object)retrievedStatus.getPermission());
        Assert.assertEquals((Object)TestBlobMetadata.getExpectedOwner(), (Object)retrievedStatus.getOwner());
        Assert.assertEquals((Object)"supergroup", (Object)retrievedStatus.getGroup());
    }

    @Test
    public void testOldPermissionMetadata() throws Exception {
        Path selfishFile = new Path("/noOneElse");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("asv_permission", TestBlobMetadata.getExpectedPermissionString("rw-------"));
        this.backingStore.setContent(AzureBlobStorageTestAccount.toMockUri(selfishFile), new byte[0], metadata, false, 0L);
        FsPermission justMe = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        FileStatus retrievedStatus = this.fs.getFileStatus(selfishFile);
        Assert.assertNotNull((Object)retrievedStatus);
        Assert.assertEquals((Object)justMe, (Object)retrievedStatus.getPermission());
        Assert.assertEquals((Object)TestBlobMetadata.getExpectedOwner(), (Object)retrievedStatus.getOwner());
        Assert.assertEquals((Object)"supergroup", (Object)retrievedStatus.getGroup());
        FsPermission meAndYou = new FsPermission(FsAction.READ_WRITE, FsAction.READ_WRITE, FsAction.NONE);
        this.fs.setPermission(selfishFile, meAndYou);
        metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri(selfishFile));
        Assert.assertNotNull(metadata);
        String storedPermission = metadata.get("hdi_permission");
        Assert.assertEquals((Object)TestBlobMetadata.getExpectedPermissionString("rw-rw----"), (Object)storedPermission);
        Assert.assertNull((Object)metadata.get("asv_permission"));
    }

    @Test
    public void testFolderMetadata() throws Exception {
        Path folder = new Path("/folder");
        FsPermission justRead = new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ);
        this.fs.mkdirs(folder, justRead);
        HashMap<String, String> metadata = this.backingStore.getMetadata(AzureBlobStorageTestAccount.toMockUri(folder));
        Assert.assertNotNull(metadata);
        Assert.assertEquals((Object)"true", (Object)metadata.get("hdi_isfolder"));
        Assert.assertEquals((Object)TestBlobMetadata.getExpectedPermissionString("r--r--r--"), (Object)metadata.get("hdi_permission"));
    }

    private static final class FsWithPreExistingContainer
    implements Closeable {
        private final MockStorageInterface mockStorage;
        private final NativeAzureFileSystem fs;

        private FsWithPreExistingContainer(MockStorageInterface mockStorage, NativeAzureFileSystem fs) {
            this.mockStorage = mockStorage;
            this.fs = fs;
        }

        public NativeAzureFileSystem getFs() {
            return this.fs;
        }

        public HashMap<String, String> getContainerMetadata() {
            return this.mockStorage.getBackingStore().getContainerMetadata();
        }

        public static FsWithPreExistingContainer create() throws Exception {
            return FsWithPreExistingContainer.create(null);
        }

        public static FsWithPreExistingContainer create(HashMap<String, String> containerMetadata) throws Exception {
            AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
            MockStorageInterface mockStorage = new MockStorageInterface();
            store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
            NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);
            Configuration conf = new Configuration();
            AzureBlobStorageTestAccount.setMockAccountKey(conf);
            mockStorage.addPreExistingContainer(AzureBlobStorageTestAccount.getMockContainerUri(), containerMetadata);
            fs.initialize(new URI("wasb://mockContainer@mockAccount.blob.core.windows.net/"), conf);
            return new FsWithPreExistingContainer(mockStorage, fs);
        }

        @Override
        public void close() throws IOException {
            this.fs.close();
        }
    }
}

