/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.junit.Test;

public class ITestBlobTypeSpeedDifference
extends AbstractWasbTestBase {
    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    private static void writeTestFile(OutputStream writeStream, long size, long flushInterval) throws IOException {
        int bufferSize = (int)Math.min(1000L, flushInterval);
        byte[] buffer = new byte[bufferSize];
        Arrays.fill(buffer, (byte)7);
        int bytesWritten = 0;
        int bytesUnflushed = 0;
        while ((long)bytesWritten < size) {
            int numberToWrite = (int)Math.min((long)bufferSize, size - (long)bytesWritten);
            writeStream.write(buffer, 0, numberToWrite);
            bytesWritten += numberToWrite;
            if ((long)(bytesUnflushed += numberToWrite) < flushInterval) continue;
            writeStream.flush();
            bytesUnflushed = 0;
        }
    }

    private static TestResult writeTestFile(NativeAzureFileSystem fs, Path path, long size, long flushInterval) throws IOException {
        AzureFileSystemInstrumentation instrumentation = fs.getInstrumentation();
        long initialRequests = instrumentation.getCurrentWebResponses();
        Date start = new Date();
        FSDataOutputStream output = fs.create(path);
        ITestBlobTypeSpeedDifference.writeTestFile((OutputStream)output, size, flushInterval);
        output.close();
        long finalRequests = instrumentation.getCurrentWebResponses();
        return new TestResult(new Date().getTime() - start.getTime(), finalRequests - initialRequests);
    }

    private static TestResult writeBlockBlobTestFile(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        return ITestBlobTypeSpeedDifference.writeTestFile(fs, new Path("/blockBlob"), size, flushInterval);
    }

    private static TestResult writePageBlobTestFile(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        Path testFile = AzureTestUtils.blobPathForTests((FileSystem)fs, "writePageBlobTestFile");
        return ITestBlobTypeSpeedDifference.writeTestFile(fs, testFile, size, flushInterval);
    }

    @Test
    public void testTenKbFileFrequentFlush() throws Exception {
        ITestBlobTypeSpeedDifference.testForSizeAndFlushInterval(this.getFileSystem(), 10000L, 500L);
    }

    private static void testForSizeAndFlushInterval(NativeAzureFileSystem fs, long size, long flushInterval) throws IOException {
        for (int i = 0; i < 5; ++i) {
            TestResult pageBlobResults = ITestBlobTypeSpeedDifference.writePageBlobTestFile(fs, size, flushInterval);
            System.out.printf("Page blob upload took %d ms. Total number of requests: %d.\n", pageBlobResults.timeTakenInMs, pageBlobResults.totalNumberOfRequests);
            TestResult blockBlobResults = ITestBlobTypeSpeedDifference.writeBlockBlobTestFile(fs, size, flushInterval);
            System.out.printf("Block blob upload took %d ms. Total number of requests: %d.\n", blockBlobResults.timeTakenInMs, blockBlobResults.totalNumberOfRequests);
        }
    }

    public static void main(String[] argv) throws Exception {
        Configuration conf = new Configuration();
        long size = 10000000L;
        long flushInterval = 2000L;
        if (argv.length > 0) {
            size = Long.parseLong(argv[0]);
        }
        if (argv.length > 1) {
            flushInterval = Long.parseLong(argv[1]);
        }
        ITestBlobTypeSpeedDifference.testForSizeAndFlushInterval((NativeAzureFileSystem)FileSystem.get((Configuration)conf), size, flushInterval);
    }

    private static class TestResult {
        final long timeTakenInMs;
        final long totalNumberOfRequests;

        TestResult(long timeTakenInMs, long totalNumberOfRequests) {
            this.timeTakenInMs = timeTakenInMs;
            this.totalNumberOfRequests = totalNumberOfRequests;
        }
    }
}

