/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.integration.AbstractAzureScaleTest;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ITestListPerformance
extends AbstractAzureScaleTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestListPerformance.class);
    private static final Path TEST_DIR_PATH = new Path("DirectoryWithManyFiles");
    private static final int NUMBER_OF_THREADS = 10;
    private static final int NUMBER_OF_FILES_PER_THREAD = 1000;
    private int threads;
    private int filesPerThread;
    private int expectedFileCount;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.threads = AzureTestUtils.getTestPropertyInt(conf, "fs.azure.scale.test.list.performance.threads", 10);
        this.filesPerThread = AzureTestUtils.getTestPropertyInt(conf, "fs.azure.scale.test.list.performance.files", 1000);
        this.expectedFileCount = this.threads * this.filesPerThread;
        LOG.info("Thread = {}, Files per Thread = {}, expected files = {}", new Object[]{this.threads, this.filesPerThread, this.expectedFileCount});
        conf.set("fs.azure.io.retry.max.retries", "1");
        conf.set("fs.azure.delete.threads", "16");
        this.createTestAccount();
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create("itestlistperformance", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.CreateContainer), null, true);
    }

    @Test
    public void test_0101_CreateDirectoryWithFiles() throws Exception {
        Assume.assumeFalse((String)"Test path exists; skipping", (boolean)this.fs.exists(TEST_DIR_PATH));
        ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
        final CloudBlobContainer container = this.testAccount.getRealContainer();
        final String basePath = (this.fs.getWorkingDirectory().toUri().getPath() + "/" + TEST_DIR_PATH + "/").substring(1);
        ArrayList<1> tasks = new ArrayList<1>(this.threads);
        this.fs.mkdirs(TEST_DIR_PATH);
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        for (int i = 0; i < this.threads; ++i) {
            tasks.add(new Callable<Integer>(){

                @Override
                public Integer call() {
                    int written = 0;
                    for (int j = 0; j < ITestListPerformance.this.filesPerThread; ++j) {
                        String blobName = basePath + UUID.randomUUID().toString();
                        try {
                            CloudBlockBlob blob = container.getBlockBlobReference(blobName);
                            blob.uploadText("");
                            ++written;
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error("Filed to write {}", (Object)blobName, (Object)e);
                            break;
                        }
                    }
                    LOG.info("Thread completed with {} files written", (Object)written);
                    return written;
                }
            });
        }
        List futures = executorService.invokeAll(tasks, this.getTestTimeoutMillis(), TimeUnit.MILLISECONDS);
        long elapsedMs = timer.elapsedTimeMs();
        LOG.info("time to create files: {} millis", (Object)elapsedMs);
        for (Future future : futures) {
            ITestListPerformance.assertTrue((String)"Future timed out", (boolean)future.isDone());
            ITestListPerformance.assertEquals((String)"Future did not write all files timed out", (long)this.filesPerThread, (long)((Integer)future.get()).intValue());
        }
    }

    @Test
    public void test_0200_ListStatusPerformance() throws Exception {
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        FileStatus[] fileList = this.fs.listStatus(TEST_DIR_PATH);
        long elapsedMs = timer.elapsedTimeMs();
        LOG.info(String.format("files=%1$d, elapsedMs=%2$d", fileList.length, elapsedMs));
        HashMap<Path, FileStatus> foundInList = new HashMap<Path, FileStatus>(this.expectedFileCount);
        for (FileStatus fileStatus : fileList) {
            foundInList.put(fileStatus.getPath(), fileStatus);
            LOG.info("{}: {}", (Object)fileStatus.getPath(), (Object)(fileStatus.isDirectory() ? "dir" : "file"));
        }
        ITestListPerformance.assertEquals((String)"Mismatch between expected files and actual", (long)this.expectedFileCount, (long)fileList.length);
        ContractTestUtils.NanoTimer initialStatusCallTimer = new ContractTestUtils.NanoTimer();
        RemoteIterator listing = this.fs.listFiles(TEST_DIR_PATH, true);
        long initialListTime = initialStatusCallTimer.elapsedTimeMs();
        timer = new ContractTestUtils.NanoTimer();
        while (listing.hasNext()) {
            FileStatus fileStatus = (FileStatus)listing.next();
            Path path = fileStatus.getPath();
            FileStatus removed = (FileStatus)foundInList.remove(path);
            ITestListPerformance.assertNotNull((String)("Did not find " + path + "{} in the previous listing"), (Object)removed);
        }
        elapsedMs = timer.elapsedTimeMs();
        LOG.info("time for listFiles() initial call: {} millis; time to iterate: {} millis", (Object)initialListTime, (Object)elapsedMs);
        ITestListPerformance.assertEquals((String)"Not all files from listStatus() were found in listFiles()", (long)0L, (long)foundInList.size());
    }

    @Test
    public void test_0300_BulkDeletePerformance() throws Exception {
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        this.fs.delete(TEST_DIR_PATH, true);
        long elapsedMs = timer.elapsedTimeMs();
        LOG.info("time for delete(): {} millis; {} nanoS per file", (Object)elapsedMs, (Object)timer.nanosPerOperation((long)this.expectedFileCount));
    }
}

