/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.junit.Test;

public class ITestNativeAzureFileSystemAtomicRenameDirList
extends AbstractWasbTestBase {
    private static final String HBASE_ROOT_DIR_CONF_STRING = "hbase.rootdir";
    private static final String HBASE_ROOT_DIR_VALUE_ON_DIFFERENT_FS = "wasb://somedifferentfilesystem.blob.core.windows.net/hbase";

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testAtomicRenameKeyDoesntNPEOnInitializingWithNonDefaultURI() throws IOException {
        NativeAzureFileSystem azureFs = this.fs;
        AzureNativeFileSystemStore azureStore = azureFs.getStore();
        Configuration conf = this.fs.getConf();
        conf.set(HBASE_ROOT_DIR_CONF_STRING, HBASE_ROOT_DIR_VALUE_ON_DIFFERENT_FS);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        azureStore.isAtomicRenameKey("anyrandomkey");
    }
}

