/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.net.URI;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Logger;
import org.junit.Test;

public class ITestNativeAzureFileSystemClientLogging
extends AbstractWasbTestBase {
    private static final String KEY_LOGGING_CONF_STRING = "fs.azure.storage.client.logging";
    private static final String TEMP_DIR = "tempDir";

    private boolean verifyStorageClientLogs(String capturedLogs, String entity) throws Exception {
        URI uri = this.testAccount.getRealAccount().getBlobEndpoint();
        String container = this.testAccount.getRealContainer().getName();
        String validateString = uri + "/" + container + "/" + entity;
        boolean entityFound = false;
        StringTokenizer tokenizer = new StringTokenizer(capturedLogs, "\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.contains(validateString)) continue;
            entityFound = true;
            break;
        }
        return entityFound;
    }

    private void updateFileSystemConfiguration(Boolean loggingFlag) throws Exception {
        Configuration conf = this.fs.getConf();
        conf.set(KEY_LOGGING_CONF_STRING, loggingFlag.toString());
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
    }

    private void performWASBOperations() throws Exception {
        Path tempDir = new Path("/tempDir");
        this.fs.mkdirs(tempDir);
        this.fs.delete(tempDir, true);
    }

    @Test
    public void testLoggingEnabled() throws Exception {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)new Log4JLogger(Logger.getRootLogger()));
        this.updateFileSystemConfiguration(true);
        this.performWASBOperations();
        String output = this.getLogOutput(logs);
        ITestNativeAzureFileSystemClientLogging.assertTrue((String)("Log entry tempDir not found  in " + output), (boolean)this.verifyStorageClientLogs(output, TEMP_DIR));
    }

    protected String getLogOutput(GenericTestUtils.LogCapturer logs) {
        String output = logs.getOutput();
        ITestNativeAzureFileSystemClientLogging.assertTrue((String)"No log created/captured", (!output.isEmpty() ? 1 : 0) != 0);
        return output;
    }

    @Test
    public void testLoggingDisabled() throws Exception {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)new Log4JLogger(Logger.getRootLogger()));
        this.updateFileSystemConfiguration(false);
        this.performWASBOperations();
        String output = this.getLogOutput(logs);
        ITestNativeAzureFileSystemClientLogging.assertFalse((String)("Log entry tempDir found  in " + output), (boolean)this.verifyStorageClientLogs(output, TEMP_DIR));
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

