/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.junit.Assert;
import org.junit.Test;

public class ITestNativeAzureFileSystemConcurrencyLive
extends AbstractWasbTestBase {
    private static final int THREAD_COUNT = 102;
    private static final int TEST_EXECUTION_TIMEOUT = 30000;

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConcurrentCreateDeleteFile() throws Exception {
        Path testFile = this.methodPath();
        ArrayList<CreateFileTask> tasks = new ArrayList<CreateFileTask>(102);
        for (int i = 0; i < 102; ++i) {
            tasks.add(new CreateFileTask((FileSystem)this.fs, testFile));
        }
        ExecutorService es = null;
        try {
            es = Executors.newFixedThreadPool(102);
            List futures = es.invokeAll(tasks);
            for (Future future : futures) {
                Assert.assertTrue((boolean)future.isDone());
                Assert.assertEquals(null, future.get());
            }
        }
        finally {
            if (es != null) {
                es.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConcurrentDeleteFile() throws Exception {
        Path testFile = new Path("test.dat");
        this.fs.create(testFile).close();
        ArrayList<DeleteFileTask> tasks = new ArrayList<DeleteFileTask>(102);
        for (int i = 0; i < 102; ++i) {
            tasks.add(new DeleteFileTask((FileSystem)this.fs, testFile));
        }
        ExecutorService es = null;
        try {
            es = Executors.newFixedThreadPool(102);
            List futures = es.invokeAll(tasks);
            int successCount = 0;
            for (Future future : futures) {
                Assert.assertTrue((boolean)future.isDone());
                Boolean success = (Boolean)future.get();
                if (!success.booleanValue()) continue;
                ++successCount;
            }
            Assert.assertEquals((String)"Exactly one delete operation should return true.", (long)1L, (long)successCount);
        }
        finally {
            if (es != null) {
                es.shutdownNow();
            }
        }
    }

    class CreateFileTask
    extends FileSystemTask<Void> {
        CreateFileTask(FileSystem fs, Path p) {
            super(fs, p);
        }

        @Override
        public Void call() throws Exception {
            FileSystem fs = this.getFileSystem();
            Path p = this.getFilePath();
            FSDataOutputStream stream = fs.create(p, true);
            stream.close();
            this.getFileSystem().delete(this.getFilePath(), false);
            return null;
        }
    }

    class DeleteFileTask
    extends FileSystemTask<Boolean> {
        DeleteFileTask(FileSystem fs, Path p) {
            super(fs, p);
        }

        @Override
        public Boolean call() throws Exception {
            return this.getFileSystem().delete(this.getFilePath(), false);
        }
    }

    abstract class FileSystemTask<V>
    implements Callable<V> {
        private final FileSystem fileSystem;
        private final Path path;

        protected FileSystem getFileSystem() {
            return this.fileSystem;
        }

        protected Path getFilePath() {
            return this.path;
        }

        FileSystemTask(FileSystem fs, Path p) {
            this.fileSystem = fs;
            this.path = p;
        }

        @Override
        public abstract V call() throws Exception;
    }
}

