/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.integration;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.util.EnumSet;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.junit.Test;

public class CleanupTestContainers
extends AbstractWasbTestBase {
    private static final String CONTAINER_PREFIX = "wasbtests-";

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create("CleanupTestContainers", EnumSet.noneOf(AzureBlobStorageTestAccount.CreateOptions.class), this.createConfiguration(), true);
    }

    @Test
    public void testEnumContainers() throws Throwable {
        this.describe("Enumerating all the WASB test containers", new Object[0]);
        int count = 0;
        CloudStorageAccount storageAccount = this.getTestAccount().getRealAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers(CONTAINER_PREFIX);
        for (CloudBlobContainer container : containers) {
            ++count;
            LOG.info("Container {} URI {}", (Object)container.getName(), (Object)container.getUri());
        }
        LOG.info("Found {} test containers", (Object)count);
    }

    @Test
    public void testDeleteContainers() throws Throwable {
        this.describe("Delete all the WASB test containers", new Object[0]);
        int count = 0;
        CloudStorageAccount storageAccount = this.getTestAccount().getRealAccount();
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        Iterable containers = blobClient.listContainers(CONTAINER_PREFIX);
        for (CloudBlobContainer container : containers) {
            LOG.info("Container {} URI {}", (Object)container.getName(), (Object)container.getUri());
            if (!container.deleteIfExists()) continue;
            ++count;
        }
        LOG.info("Deleted {} test containers", (Object)count);
    }
}

