/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Date;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.AzureMetricsTestUtil;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.test.MetricsAsserts;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureFileSystemInstrumentation
extends AbstractWasbTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ITestAzureFileSystemInstrumentation.class);

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testMetricTags() throws Exception {
        String accountName = this.getTestAccount().getRealAccount().getBlobEndpoint().getAuthority();
        String containerName = this.getTestAccount().getRealContainer().getName();
        MetricsRecordBuilder myMetrics = this.getMyMetrics();
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("accountName", accountName)));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("containerName", containerName)));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagMatcher("Context", "azureFileSystem")));
        ((MetricsRecordBuilder)Mockito.verify((Object)myMetrics)).add((MetricsTag)Matchers.argThat((Matcher)new TagExistsMatcher("wasbFileSystemId")));
    }

    @Test
    public void testMetricsOnMkdirList() throws Exception {
        long base = this.getBaseWebResponses();
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.fs.mkdirs(new Path("a")));
        base = this.assertWebResponsesInRange(base, 1L, 18L);
        ITestAzureFileSystemInstrumentation.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_directories_created"));
        ITestAzureFileSystemInstrumentation.assertEquals((long)1L, (long)this.getFileSystem().listStatus(new Path("/")).length);
        base = this.assertWebResponsesEquals(base, 1L);
        this.assertNoErrors();
    }

    private BandwidthGaugeUpdater getBandwidthGaugeUpdater() {
        NativeAzureFileSystem azureFs = this.getFileSystem();
        AzureNativeFileSystemStore azureStore = azureFs.getStore();
        return azureStore.getBandwidthGaugeUpdater();
    }

    private static byte[] nonZeroByteArray(int size) {
        byte[] data = new byte[size];
        Arrays.fill(data, (byte)5);
        return data;
    }

    @Test
    public void testMetricsOnFileCreateRead() throws Exception {
        long base = this.getBaseWebResponses();
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten(this.getInstrumentation()));
        Path filePath = new Path("/metricsTest_webResponses");
        int FILE_SIZE = 1000;
        this.getBandwidthGaugeUpdater().suppressAutoUpdate();
        Date start = new Date();
        FSDataOutputStream outputStream = this.getFileSystem().create(filePath);
        outputStream.write(ITestAzureFileSystemInstrumentation.nonZeroByteArray(1000));
        outputStream.close();
        long uploadDurationMs = new Date().getTime() - start.getTime();
        this.logOpResponseCount("Creating a 1K file", base);
        base = this.assertWebResponsesInRange(base, 2L, 15L);
        this.getBandwidthGaugeUpdater().triggerUpdate(true);
        long bytesWritten = AzureMetricsTestUtil.getCurrentBytesWritten(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The bytes written in the last second " + bytesWritten + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (bytesWritten > 500L && bytesWritten < 2000L ? 1 : 0) != 0);
        long totalBytesWritten = AzureMetricsTestUtil.getCurrentTotalBytesWritten(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The total bytes written  " + totalBytesWritten + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (totalBytesWritten >= 1000L && totalBytesWritten < 2000L ? 1 : 0) != 0);
        long uploadRate = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_maximum_upload_bytes_per_second");
        LOG.info("Upload rate: " + uploadRate + " bytes/second.");
        long expectedRate = 1000000L / uploadDurationMs;
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The upload rate " + uploadRate + " is below the expected range of around " + expectedRate + " bytes/second that the unit test observed. This should never be the case since the test underestimates the rate by looking at  end-to-end time instead of just block upload time."), (uploadRate >= expectedRate ? 1 : 0) != 0);
        long uploadLatency = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_average_block_upload_latency_ms");
        LOG.info("Upload latency: {}", (Object)uploadLatency);
        long expectedLatency = uploadDurationMs;
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The upload latency " + uploadLatency + " should be greater than zero now that I've just uploaded a file."), (uploadLatency > 0L ? 1 : 0) != 0);
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The upload latency " + uploadLatency + " is more than the expected range of around " + expectedLatency + " milliseconds that the unit test observed. This should never be the case since the test overestimates the latency by looking at  end-to-end time instead of just block upload time."), (uploadLatency <= expectedLatency ? 1 : 0) != 0);
        start = new Date();
        FSDataInputStream inputStream = this.getFileSystem().open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        long downloadDurationMs = new Date().getTime() - start.getTime();
        ITestAzureFileSystemInstrumentation.assertEquals((long)1000L, (long)count);
        this.logOpResponseCount("Reading a 1K file", base);
        base = this.assertWebResponsesInRange(base, 1L, 10L);
        this.getBandwidthGaugeUpdater().triggerUpdate(false);
        long totalBytesRead = AzureMetricsTestUtil.getCurrentTotalBytesRead(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertEquals((long)1000L, (long)totalBytesRead);
        long bytesRead = AzureMetricsTestUtil.getCurrentBytesRead(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The bytes read in the last second " + bytesRead + " is pretty far from the expected range of around " + 1000 + " bytes plus a little overhead."), (bytesRead > 500L && bytesRead < 2000L ? 1 : 0) != 0);
        long downloadRate = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_maximum_download_bytes_per_second");
        LOG.info("Download rate: " + downloadRate + " bytes/second.");
        expectedRate = 1000000L / downloadDurationMs;
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The download rate " + downloadRate + " is below the expected range of around " + expectedRate + " bytes/second that the unit test observed. This should never be the case since the test underestimates the rate by looking at  end-to-end time instead of just block download time."), (downloadRate >= expectedRate ? 1 : 0) != 0);
        long downloadLatency = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_average_block_download_latency_ms");
        LOG.info("Download latency: " + downloadLatency);
        expectedLatency = downloadDurationMs;
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The download latency " + downloadLatency + " should be greater than zero now that I've just downloaded a file."), (downloadLatency > 0L ? 1 : 0) != 0);
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The download latency " + downloadLatency + " is more than the expected range of around " + expectedLatency + " milliseconds that the unit test observed. This should never be the case since the test overestimates the latency by looking at  end-to-end time instead of just block download time."), (downloadLatency <= expectedLatency ? 1 : 0) != 0);
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnBigFileCreateRead() throws Exception {
        long base = this.getBaseWebResponses();
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getCurrentBytesWritten(this.getInstrumentation()));
        Path filePath = new Path("/metricsTest_webResponses");
        int FILE_SIZE = 0x6400000;
        this.getBandwidthGaugeUpdater().suppressAutoUpdate();
        FSDataOutputStream outputStream = this.getFileSystem().create(filePath);
        outputStream.write(new byte[0x6400000]);
        outputStream.close();
        this.logOpResponseCount("Creating a 100 MB file", base);
        base = this.assertWebResponsesInRange(base, 20L, 50L);
        this.getBandwidthGaugeUpdater().triggerUpdate(true);
        long totalBytesWritten = AzureMetricsTestUtil.getCurrentTotalBytesWritten(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The total bytes written  " + totalBytesWritten + " is pretty far from the expected range of around " + 0x6400000 + " bytes plus a little overhead."), (totalBytesWritten >= 0x6400000L && totalBytesWritten < 0xC800000L ? 1 : 0) != 0);
        long uploadRate = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_maximum_upload_bytes_per_second");
        LOG.info("Upload rate: " + uploadRate + " bytes/second.");
        long uploadLatency = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_average_block_upload_latency_ms");
        LOG.info("Upload latency: " + uploadLatency);
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The upload latency " + uploadLatency + " should be greater than zero now that I've just uploaded a file."), (uploadLatency > 0L ? 1 : 0) != 0);
        FSDataInputStream inputStream = this.getFileSystem().open(filePath);
        int count = 0;
        while (inputStream.read() >= 0) {
            ++count;
        }
        inputStream.close();
        ITestAzureFileSystemInstrumentation.assertEquals((long)0x6400000L, (long)count);
        this.logOpResponseCount("Reading a 100 MB file", base);
        base = this.assertWebResponsesInRange(base, 20L, 40L);
        this.getBandwidthGaugeUpdater().triggerUpdate(false);
        long totalBytesRead = AzureMetricsTestUtil.getCurrentTotalBytesRead(this.getInstrumentation());
        ITestAzureFileSystemInstrumentation.assertEquals((long)0x6400000L, (long)totalBytesRead);
        long downloadRate = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_maximum_download_bytes_per_second");
        LOG.info("Download rate: " + downloadRate + " bytes/second.");
        long downloadLatency = AzureMetricsTestUtil.getLongGaugeValue(this.getInstrumentation(), "wasb_average_block_download_latency_ms");
        LOG.info("Download latency: " + downloadLatency);
        ITestAzureFileSystemInstrumentation.assertTrue((String)("The download latency " + downloadLatency + " should be greater than zero now that I've just downloaded a file."), (downloadLatency > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMetricsOnFileRename() throws Exception {
        long base = this.getBaseWebResponses();
        Path originalPath = new Path("/metricsTest_RenameStart");
        Path destinationPath = new Path("/metricsTest_RenameFinal");
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_files_created"));
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().createNewFile(originalPath));
        this.logOpResponseCount("Creating an empty file", base);
        base = this.assertWebResponsesInRange(base, 2L, 20L);
        ITestAzureFileSystemInstrumentation.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_files_created"));
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().rename(originalPath, destinationPath));
        this.logOpResponseCount("Renaming a file", base);
        base = this.assertWebResponsesInRange(base, 2L, 15L);
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnFileExistsDelete() throws Exception {
        long base = this.getBaseWebResponses();
        Path filePath = new Path("/metricsTest_delete");
        ITestAzureFileSystemInstrumentation.assertFalse((boolean)this.getFileSystem().exists(filePath));
        this.logOpResponseCount("Checking file existence for non-existent file", base);
        base = this.assertWebResponsesInRange(base, 1L, 5L);
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().createNewFile(filePath));
        base = this.getCurrentWebResponses();
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().exists(filePath));
        this.logOpResponseCount("Checking file existence for existent file", base);
        base = this.assertWebResponsesInRange(base, 1L, 4L);
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_files_deleted"));
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().delete(filePath, false));
        this.logOpResponseCount("Deleting a file", base);
        base = this.assertWebResponsesInRange(base, 1L, 4L);
        ITestAzureFileSystemInstrumentation.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_files_deleted"));
        this.assertNoErrors();
    }

    @Test
    public void testMetricsOnDirRename() throws Exception {
        long base = this.getBaseWebResponses();
        Path originalDirName = new Path("/metricsTestDirectory_RenameStart");
        Path innerFileName = new Path(originalDirName, "innerFile");
        Path destDirName = new Path("/metricsTestDirectory_RenameFinal");
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().mkdirs(originalDirName));
        base = this.getCurrentWebResponses();
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().createNewFile(innerFileName));
        base = this.getCurrentWebResponses();
        ITestAzureFileSystemInstrumentation.assertTrue((boolean)this.getFileSystem().rename(originalDirName, destDirName));
        this.logOpResponseCount("Renaming a directory", base);
        base = this.assertWebResponsesInRange(base, 1L, 20L);
        this.assertNoErrors();
    }

    int depth(Path path) {
        if (path.isRoot()) {
            return 0;
        }
        return 1 + this.depth(path.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testClientErrorMetrics() throws Exception {
        FSDataOutputStream outputStream;
        block5: {
            String fileName = "metricsTestFile_ClientError";
            Path filePath = new Path("/" + fileName);
            int FILE_SIZE = 100;
            outputStream = null;
            String leaseID = null;
            try {
                outputStream = this.getFileSystem().create(filePath);
                leaseID = this.getTestAccount().acquireShortLease(fileName);
                try {
                    outputStream.write(new byte[100]);
                    outputStream.close();
                    ITestAzureFileSystemInstrumentation.assertTrue((String)"Should've thrown", (boolean)false);
                }
                catch (AzureException ex) {
                    ITestAzureFileSystemInstrumentation.assertTrue((String)("Unexpected exception: " + (Object)((Object)ex)), (boolean)ex.getMessage().contains("lease"));
                }
                ITestAzureFileSystemInstrumentation.assertEquals((long)1L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_client_errors"));
                ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_server_errors"));
                if (leaseID == null) break block5;
            }
            catch (Throwable throwable) {
                if (leaseID != null) {
                    this.getTestAccount().releaseLease(leaseID, fileName);
                }
                IOUtils.closeStream((Closeable)outputStream);
                throw throwable;
            }
            this.getTestAccount().releaseLease(leaseID, fileName);
        }
        IOUtils.closeStream((Closeable)outputStream);
    }

    private void logOpResponseCount(String opName, long base) {
        LOG.info("{}  took {} web responses to complete.", (Object)opName, (Object)(this.getCurrentWebResponses() - base));
    }

    private long getBaseWebResponses() {
        return this.assertWebResponsesEquals(0L, 0L);
    }

    private long getCurrentWebResponses() {
        return AzureMetricsTestUtil.getCurrentWebResponses(this.getInstrumentation());
    }

    private long assertWebResponsesEquals(long base, long expected) {
        MetricsAsserts.assertCounter((String)"wasb_web_responses", (long)(base + expected), (MetricsRecordBuilder)this.getMyMetrics());
        return base + expected;
    }

    private void assertNoErrors() {
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_client_errors"));
        ITestAzureFileSystemInstrumentation.assertEquals((long)0L, (long)AzureMetricsTestUtil.getLongCounterValue(this.getInstrumentation(), "wasb_server_errors"));
    }

    private long assertWebResponsesInRange(long base, long inclusiveLowerLimit, long inclusiveUpperLimit) {
        long currentResponses = this.getCurrentWebResponses();
        long justOperation = currentResponses - base;
        ITestAzureFileSystemInstrumentation.assertTrue((String)String.format("Web responses expected in range [%d, %d], but was %d.", inclusiveLowerLimit, inclusiveUpperLimit, justOperation), (justOperation >= inclusiveLowerLimit && justOperation <= inclusiveUpperLimit ? 1 : 0) != 0);
        return currentResponses;
    }

    private MetricsRecordBuilder getMyMetrics() {
        return MetricsAsserts.getMetrics((MetricsSource)this.getInstrumentation());
    }

    private AzureFileSystemInstrumentation getInstrumentation() {
        return this.getFileSystem().getInstrumentation();
    }

    private static class InRange
    extends BaseMatcher<Long> {
        private final long inclusiveLowerLimit;
        private final long inclusiveUpperLimit;
        private long obtained;

        public InRange(long inclusiveLowerLimit, long inclusiveUpperLimit) {
            this.inclusiveLowerLimit = inclusiveLowerLimit;
            this.inclusiveUpperLimit = inclusiveUpperLimit;
        }

        public boolean matches(Object number) {
            this.obtained = (Long)number;
            return this.obtained >= this.inclusiveLowerLimit && this.obtained <= this.inclusiveUpperLimit;
        }

        public void describeTo(Description description) {
            description.appendText("Between " + this.inclusiveLowerLimit + " and " + this.inclusiveUpperLimit + " inclusively");
        }
    }

    private static class TagExistsMatcher
    extends BaseMatcher<MetricsTag> {
        private final String tagName;

        public TagExistsMatcher(String tagName) {
            this.tagName = tagName;
        }

        public boolean matches(Object toMatch) {
            MetricsTag asTag = (MetricsTag)toMatch;
            return asTag.name().equals(this.tagName) && this.matches(asTag);
        }

        protected boolean matches(MetricsTag toMatch) {
            return true;
        }

        public void describeTo(Description desc) {
            desc.appendText("Has tag " + this.tagName);
        }
    }

    private static class TagMatcher
    extends TagExistsMatcher {
        private final String tagValue;

        public TagMatcher(String tagName, String tagValue) {
            super(tagName);
            this.tagValue = tagValue;
        }

        @Override
        public boolean matches(MetricsTag toMatch) {
            return toMatch.value().equals(this.tagValue);
        }

        @Override
        public void describeTo(Description desc) {
            super.describeTo(desc);
            desc.appendText(" with value " + this.tagValue);
        }
    }
}

