/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAbfsIntegrationTest
extends AbstractAbfsTestWithTimeout {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAbfsIntegrationTest.class);
    private boolean isIPAddress;
    private NativeAzureFileSystem wasb;
    private AzureBlobFileSystem abfs;
    private String abfsScheme;
    private Configuration rawConfig;
    private AbfsConfiguration abfsConfig;
    private String fileSystemName = "abfs-testcontainer-" + UUID.randomUUID().toString();
    private String accountName;
    private String testUrl;
    private AuthType authType;

    protected AbstractAbfsIntegrationTest() throws Exception {
        this.rawConfig = new Configuration();
        this.rawConfig.addResource("azure-test.xml");
        this.accountName = this.rawConfig.get("fs.azure.account.name");
        if (this.accountName == null) {
            this.accountName = this.rawConfig.get("fs.azure.abfs.account.name");
        }
        Assume.assumeTrue((String)"Not set: fs.azure.abfs.account.name", (this.accountName != null && !this.accountName.isEmpty() ? 1 : 0) != 0);
        this.abfsConfig = new AbfsConfiguration(this.rawConfig, this.accountName);
        this.authType = (AuthType)this.abfsConfig.getEnum("fs.azure.account.auth.type", (Enum)AuthType.SharedKey);
        String string = this.abfsScheme = this.authType == AuthType.SharedKey ? "abfs" : "abfss";
        if (this.authType == AuthType.SharedKey) {
            Assume.assumeTrue((String)"Not set: fs.azure.account.key", (this.abfsConfig.get("fs.azure.account.key") != null ? 1 : 0) != 0);
        } else {
            Assume.assumeTrue((String)"Not set: fs.azure.account.oauth.provider.type", (this.abfsConfig.get("fs.azure.account.oauth.provider.type") != null ? 1 : 0) != 0);
        }
        String abfsUrl = this.getFileSystemName() + "@" + this.getAccountName();
        URI defaultUri = null;
        try {
            defaultUri = new URI(this.abfsScheme, abfsUrl, null, null, null);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        this.testUrl = defaultUri.toString();
        this.abfsConfig.set("fs.defaultFS", defaultUri.toString());
        this.abfsConfig.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        String endPoint = this.abfsConfig.get("fs.azure.abfs.endpoint");
        this.isIPAddress = endPoint != null && endPoint.contains(":") && endPoint.split(":").length == 2;
    }

    @Before
    public void setup() throws Exception {
        this.createFileSystem();
        if (!this.isIPAddress && !this.abfs.getIsNamespaceEnabled()) {
            URI wasbUri = new URI(AbstractAbfsIntegrationTest.abfsUrlToWasbUrl(this.getTestUrl()));
            AzureNativeFileSystemStore azureNativeFileSystemStore = new AzureNativeFileSystemStore();
            String accountNameWithoutDomain = this.accountName.split("\\.")[0];
            String wasbAccountName = accountNameWithoutDomain + ".blob.core.windows.net";
            String keyProperty = "fs.azure.account.key." + wasbAccountName;
            if (this.rawConfig.get(keyProperty) == null) {
                this.rawConfig.set(keyProperty, this.getAccountKey());
            }
            azureNativeFileSystemStore.initialize(wasbUri, this.rawConfig, new AzureFileSystemInstrumentation(this.rawConfig));
            this.wasb = new NativeAzureFileSystem((NativeFileSystemStore)azureNativeFileSystemStore);
            this.wasb.initialize(wasbUri, this.rawConfig);
        }
    }

    @After
    public void teardown() throws Exception {
        try {
            IOUtils.closeStream((Closeable)this.wasb);
            this.wasb = null;
            if (this.abfs == null) {
                return;
            }
            final AzureBlobFileSystemStore abfsStore = this.abfs.getAbfsStore();
            abfsStore.deleteFilesystem();
            AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, (Callable)new Callable<Hashtable<String, String>>(){

                @Override
                public Hashtable<String, String> call() throws Exception {
                    return abfsStore.getFilesystemProperties();
                }
            });
            if (AzureServiceErrorCode.FILE_SYSTEM_NOT_FOUND.getStatusCode() != ex.getStatusCode()) {
                LOG.warn("Deleted test filesystem may still exist: {}", (Object)this.abfs, (Object)ex);
            }
        }
        catch (Exception e) {
            LOG.warn("During cleanup: {}", (Object)e, (Object)e);
        }
        finally {
            IOUtils.closeStream((Closeable)this.abfs);
            this.abfs = null;
        }
    }

    public AzureBlobFileSystem getFileSystem() throws IOException {
        return this.abfs;
    }

    public AzureBlobFileSystem getFileSystem(Configuration configuration) throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)configuration);
        return fs;
    }

    public AzureBlobFileSystem getFileSystem(String abfsUri) throws Exception {
        this.abfsConfig.set("fs.defaultFS", abfsUri);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)this.rawConfig);
        return fs;
    }

    public AzureBlobFileSystem createFileSystem() throws IOException {
        if (this.abfs == null) {
            this.abfs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.rawConfig);
        }
        return this.abfs;
    }

    protected NativeAzureFileSystem getWasbFileSystem() {
        return this.wasb;
    }

    protected String getHostName() {
        String endPoint = this.abfsConfig.get("fs.azure.abfs.endpoint");
        return endPoint.split(":")[0];
    }

    protected void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    protected String getTestUrl() {
        return this.testUrl;
    }

    protected void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    protected String getFileSystemName() {
        return this.fileSystemName;
    }

    protected String getAccountName() {
        return this.accountName;
    }

    protected String getAccountKey() {
        return this.abfsConfig.get("fs.azure.account.key");
    }

    public AbfsConfiguration getConfiguration() {
        return this.abfsConfig;
    }

    public Configuration getRawConfiguration() {
        return this.abfsConfig.getRawConfiguration();
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getAbfsScheme() {
        return this.abfsScheme;
    }

    protected boolean isIPAddress() {
        return this.isIPAddress;
    }

    protected void write(Path path, byte[] buffer) throws IOException {
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)path, (byte[])buffer, (int)buffer.length, (int)4096, (boolean)false);
    }

    protected void touch(Path path) throws IOException {
        ContractTestUtils.touch((FileSystem)this.getFileSystem(), (Path)path);
    }

    protected static String wasbUrlToAbfsUrl(String wasbUrl) {
        return AbstractAbfsIntegrationTest.convertTestUrls(wasbUrl, "wasb", "wasbs", "blob", "abfs", "abfss", "dfs");
    }

    protected static String abfsUrlToWasbUrl(String abfsUrl) {
        return AbstractAbfsIntegrationTest.convertTestUrls(abfsUrl, "abfs", "abfss", "dfs", "wasb", "wasbs", "blob");
    }

    private static String convertTestUrls(String url, String fromNonSecureScheme, String fromSecureScheme, String fromDnsPrefix, String toNonSecureScheme, String toSecureScheme, String toDnsPrefix) {
        String data = null;
        if (url.startsWith(fromNonSecureScheme + "://")) {
            data = url.replace(fromNonSecureScheme + "://", toNonSecureScheme + "://");
        } else if (url.startsWith(fromSecureScheme + "://")) {
            data = url.replace(fromSecureScheme + "://", toSecureScheme + "://");
        }
        if (data != null) {
            data = data.replace("." + fromDnsPrefix + ".", "." + toDnsPrefix + ".");
        }
        return data;
    }

    public Path getTestPath() {
        Path path = new Path(UriUtils.generateUniqueTestPath());
        return path;
    }

    protected Path path(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(this.getTestPath(), filepath));
    }
}

