/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public final class ITestAbfsClient
extends AbstractAbfsIntegrationTest {
    private static final int LIST_MAX_RESULTS = 500;

    @Test
    public void testContinuationTokenHavingEqualSign() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient abfsClient = fs.getAbfsClient();
        try {
            AbfsRestOperation op = abfsClient.listPath("/", true, 500, "===========");
            Assert.assertTrue((boolean)false);
        }
        catch (AbfsRestOperationException ex) {
            Assert.assertEquals((Object)"InvalidQueryParameterValue", (Object)ex.getErrorCode().getErrorCode());
        }
    }

    @Ignore(value="Enable this to verify the log warning message format for HostNotFoundException")
    @Test
    public void testUnknownHost() throws Exception {
        AbfsConfiguration conf = this.getConfiguration();
        String accountName = this.getAccountName();
        String fakeAccountName = "fake" + UUID.randomUUID() + accountName.substring(accountName.indexOf("."));
        String fsDefaultFS = conf.get("fs.defaultFS");
        conf.set("fs.defaultFS", fsDefaultFS.replace(accountName, fakeAccountName));
        conf.set("fs.azure.account.key." + fakeAccountName, this.getAccountKey());
        LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)("UnknownHostException: " + fakeAccountName), () -> FileSystem.get((Configuration)conf.getRawConfiguration()));
    }
}

