/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class ITestAbfsRestOperationException
extends AbstractAbfsIntegrationTest {
    @Test
    public void testAbfsRestOperationExceptionFormat() throws IOException {
        String[] errorFields;
        String errorMessage;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nonExistedFilePath1 = new Path("nonExistedPath1");
        Path nonExistedFilePath2 = new Path("nonExistedPath2");
        try {
            FileStatus fileStatus = fs.getFileStatus(nonExistedFilePath1);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            Assert.assertEquals((long)4L, (long)errorFields.length);
            Assert.assertEquals((Object)"Operation failed: \"The specified path does not exist.\"", (Object)errorFields[0].trim());
            Assert.assertEquals((Object)"404", (Object)errorFields[1].trim());
            Assert.assertEquals((Object)"HEAD", (Object)errorFields[2].trim());
            Assert.assertTrue((boolean)errorFields[3].trim().startsWith("http"));
        }
        try {
            fs.listFiles(nonExistedFilePath2, false);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            Assert.assertEquals((long)6L, (long)errorFields.length);
            Assert.assertEquals((Object)"Operation failed: \"The specified path does not exist.\"", (Object)errorFields[0].trim());
            Assert.assertEquals((Object)"404", (Object)errorFields[1].trim());
            Assert.assertEquals((Object)"GET", (Object)errorFields[2].trim());
            Assert.assertTrue((boolean)errorFields[3].trim().startsWith("http"));
            Assert.assertEquals((Object)"PathNotFound", (Object)errorFields[4].trim());
            Assert.assertTrue((errorFields[5].contains("RequestId") && errorFields[5].contains("Time") ? 1 : 0) != 0);
        }
    }
}

