/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public class ITestAzureBlobFileSystemAppend
extends AbstractAbfsIntegrationTest {
    private static final Path TEST_FILE_PATH = new Path("testfile");
    private static final Path TEST_FOLDER_PATH = new Path("testFolder");

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirShouldFail() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = TEST_FILE_PATH;
        fs.mkdirs(filePath);
        fs.append(filePath, 0);
    }

    @Test
    public void testAppendWithLength0() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(TEST_FILE_PATH);){
            byte[] b = new byte[1024];
            new Random().nextBytes(b);
            stream.write(b, 1000, 0);
            ITestAzureBlobFileSystemAppend.assertEquals((long)0L, (long)stream.getPos());
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = TEST_FILE_PATH;
        ContractTestUtils.touch((FileSystem)fs, (Path)filePath);
        fs.delete(filePath, false);
        fs.append(filePath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = TEST_FOLDER_PATH;
        fs.mkdirs(folderPath);
        fs.append(folderPath);
    }
}

