/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.extensions.AbfsAuthorizationException;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemAuthorization
extends AbstractAbfsIntegrationTest {
    private static final Path TEST_READ_ONLY_FILE_PATH_0 = new Path("readOnlyFile0");
    private static final Path TEST_READ_ONLY_FOLDER_PATH = new Path("readOnlyFolder");
    private static final Path TEST_WRITE_ONLY_FILE_PATH_0 = new Path("writeOnlyFile0");
    private static final Path TEST_WRITE_ONLY_FILE_PATH_1 = new Path("writeOnlyFile1");
    private static final Path TEST_READ_WRITE_FILE_PATH_0 = new Path("readWriteFile0");
    private static final Path TEST_READ_WRITE_FILE_PATH_1 = new Path("readWriteFile1");
    private static final Path TEST_WRITE_ONLY_FOLDER_PATH = new Path("writeOnlyFolder");
    private static final Path TEST_WRITE_THEN_READ_ONLY_PATH = new Path("writeThenReadOnlyFile");
    private static final String TEST_AUTHZ_CLASS = "org.apache.hadoop.fs.azurebfs.extensions.MockAbfsAuthorizer";
    private static final String TEST_USER = UUID.randomUUID().toString();
    private static final String TEST_GROUP = UUID.randomUUID().toString();
    private static final String BAR = UUID.randomUUID().toString();

    @Override
    public void setup() throws Exception {
        this.getConfiguration().set("abfs.external.authorization.class", TEST_AUTHZ_CLASS);
        super.setup();
    }

    @Test
    public void testOpenFileWithInvalidPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> fs.open(new Path("")).close());
    }

    @Test
    public void testOpenFileAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        fs.open(TEST_WRITE_THEN_READ_ONLY_PATH).close();
    }

    @Test
    public void testOpenFileUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.open(TEST_WRITE_ONLY_FILE_PATH_0).close());
    }

    @Test
    public void testCreateFileAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
    }

    @Test
    public void testCreateFileUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.create(TEST_READ_ONLY_FILE_PATH_0).close());
    }

    @Test
    public void testAppendFileAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.append(TEST_WRITE_ONLY_FILE_PATH_0).close();
    }

    @Test
    public void testAppendFileUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.append(TEST_WRITE_THEN_READ_ONLY_PATH).close());
    }

    @Test
    public void testRenameAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.rename(TEST_READ_WRITE_FILE_PATH_0, TEST_READ_WRITE_FILE_PATH_1);
    }

    @Test
    public void testRenameUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.rename(TEST_WRITE_ONLY_FILE_PATH_0, TEST_WRITE_ONLY_FILE_PATH_1));
    }

    @Test
    public void testDeleteFileAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.delete(TEST_WRITE_ONLY_FILE_PATH_0, false);
    }

    @Test
    public void testDeleteFileUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.delete(TEST_WRITE_THEN_READ_ONLY_PATH, false));
    }

    @Test
    public void testListStatusAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        fs.listStatus(TEST_WRITE_THEN_READ_ONLY_PATH);
    }

    @Test
    public void testListStatusUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.listStatus(TEST_WRITE_ONLY_FILE_PATH_0));
    }

    @Test
    public void testMkDirsAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(TEST_WRITE_ONLY_FOLDER_PATH, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
    }

    @Test
    public void testMkDirsUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.mkdirs(TEST_READ_ONLY_FOLDER_PATH, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE)));
    }

    @Test
    public void testGetFileStatusAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        fs.getFileStatus(TEST_WRITE_THEN_READ_ONLY_PATH);
    }

    @Test
    public void testGetFileStatusUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.getFileStatus(TEST_WRITE_ONLY_FILE_PATH_0));
    }

    @Test
    public void testSetOwnerAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.setOwner(TEST_WRITE_ONLY_FILE_PATH_0, TEST_USER, TEST_GROUP);
    }

    @Test
    public void testSetOwnerUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.setOwner(TEST_WRITE_THEN_READ_ONLY_PATH, TEST_USER, TEST_GROUP));
    }

    @Test
    public void testSetPermissionAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.setPermission(TEST_WRITE_ONLY_FILE_PATH_0, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
    }

    @Test
    public void testSetPermissionUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.setPermission(TEST_WRITE_THEN_READ_ONLY_PATH, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE)));
    }

    @Test
    public void testModifyAclEntriesAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        fs.modifyAclEntries(TEST_WRITE_ONLY_FILE_PATH_0, aclSpec);
    }

    @Test
    public void testModifyAclEntriesUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.modifyAclEntries(TEST_WRITE_THEN_READ_ONLY_PATH, aclSpec));
    }

    @Test
    public void testRemoveAclEntriesAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        fs.removeAclEntries(TEST_WRITE_ONLY_FILE_PATH_0, aclSpec);
    }

    @Test
    public void testRemoveAclEntriesUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.removeAclEntries(TEST_WRITE_THEN_READ_ONLY_PATH, aclSpec));
    }

    @Test
    public void testRemoveDefaultAclAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.removeDefaultAcl(TEST_WRITE_ONLY_FILE_PATH_0);
    }

    @Test
    public void testRemoveDefaultAclUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.removeDefaultAcl(TEST_WRITE_THEN_READ_ONLY_PATH));
    }

    @Test
    public void testRemoveAclAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        fs.removeAcl(TEST_WRITE_ONLY_FILE_PATH_0);
    }

    @Test
    public void testRemoveAclUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.removeAcl(TEST_WRITE_THEN_READ_ONLY_PATH));
    }

    @Test
    public void testSetAclAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        fs.setAcl(TEST_WRITE_ONLY_FILE_PATH_0, aclSpec);
    }

    @Test
    public void testSetAclUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.setAcl(TEST_WRITE_THEN_READ_ONLY_PATH, aclSpec));
    }

    @Test
    public void testGetAclStatusAuthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_THEN_READ_ONLY_PATH).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        fs.getAclStatus(TEST_WRITE_THEN_READ_ONLY_PATH);
    }

    @Test
    public void testGetAclStatusUnauthorized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((String)"This test case only runs when namespace is enabled", (boolean)fs.getIsNamespaceEnabled());
        fs.create(TEST_WRITE_ONLY_FILE_PATH_0).close();
        List<AclEntry> aclSpec = Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, BAR, FsAction.ALL));
        LambdaTestUtils.intercept(AbfsAuthorizationException.class, () -> fs.getAclStatus(TEST_WRITE_ONLY_FILE_PATH_0));
    }
}

