/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureBlobFileSystemRandomRead
extends AbstractAbfsScaleTest {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final long TEST_FILE_SIZE = 0x800000L;
    private static final int MAX_ELAPSEDTIMEMS = 20;
    private static final int SEQUENTIAL_READ_BUFFER_SIZE = 16384;
    private static final int CREATE_BUFFER_SIZE = 26624;
    private static final int SEEK_POSITION_ONE = 2048;
    private static final int SEEK_POSITION_TWO = 5120;
    private static final int SEEK_POSITION_THREE = 10240;
    private static final int SEEK_POSITION_FOUR = 0x401000;
    private static final Path TEST_FILE_PATH = new Path("/TestRandomRead.txt");
    private static final String WASB = "WASB";
    private static final String ABFS = "ABFS";
    private static long testFileLength = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ITestAzureBlobFileSystemRandomRead.class);

    @Test
    public void testBasicRead() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            byte[] buffer = new byte[0x300000];
            inputStream.seek(0x500000L);
            int numBytesRead = inputStream.read(buffer, 0, 1024);
            ITestAzureBlobFileSystemRandomRead.assertEquals((String)"Wrong number of bytes read", (long)1024L, (long)numBytesRead);
            int len = 0x100000;
            int offset = buffer.length - len;
            inputStream.seek(0x300000L);
            numBytesRead = inputStream.read(buffer, offset, len);
            ITestAzureBlobFileSystemRandomRead.assertEquals((String)"Wrong number of bytes read after seek", (long)len, (long)numBytesRead);
        }
    }

    @Test
    public void testRandomRead() throws Exception {
        Assume.assumeFalse((String)"This test does not support namespace enabled account", (boolean)this.getFileSystem().getIsNamespaceEnabled());
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStreamV1 = this.getFileSystem().open(TEST_FILE_PATH);
             FSDataInputStream inputStreamV2 = this.getWasbFileSystem().open(TEST_FILE_PATH);){
            int bufferSize = 4096;
            byte[] bufferV1 = new byte[4096];
            byte[] bufferV2 = new byte[bufferV1.length];
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            inputStreamV1.seek(0L);
            inputStreamV2.seek(0L);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            inputStreamV1.seek(2048L);
            inputStreamV2.seek(2048L);
            inputStreamV1.seek(0L);
            inputStreamV2.seek(0L);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            inputStreamV1.seek(5120L);
            inputStreamV2.seek(5120L);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            inputStreamV1.seek(10240L);
            inputStreamV2.seek(10240L);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
            inputStreamV1.seek(0x401000L);
            inputStreamV2.seek(0x401000L);
            this.verifyConsistentReads(inputStreamV1, inputStreamV2, bufferV1, bufferV2);
        }
    }

    @Test
    public void testSeekToNewSource() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            ITestAzureBlobFileSystemRandomRead.assertFalse((boolean)inputStream.seekToNewSource(0L));
        }
    }

    @Test
    public void testSkipBounds() throws Exception {
        this.assumeHugeFileExists();
        try (final FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
            long skipped = inputStream.skip(-1L);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)0L, (long)skipped);
            skipped = inputStream.skip(0L);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)0L, (long)skipped);
            ITestAzureBlobFileSystemRandomRead.assertTrue((testFileLength > 0L ? 1 : 0) != 0);
            skipped = inputStream.skip(testFileLength);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)testFileLength, (long)skipped);
            LambdaTestUtils.intercept(EOFException.class, (Callable)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return inputStream.skip(1L);
                }
            });
            long elapsedTimeMs = timer.elapsedTimeMs();
            ITestAzureBlobFileSystemRandomRead.assertTrue((String)String.format("There should not be any network I/O (elapsedTimeMs=%1$d).", elapsedTimeMs), (elapsedTimeMs < 20L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidateSeekBounds() throws Exception {
        this.assumeHugeFileExists();
        try (final FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
            inputStream.seek(0L);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)0L, (long)inputStream.getPos());
            LambdaTestUtils.intercept(EOFException.class, (String)"Cannot seek to a negative offset", (Callable)new Callable<FSDataInputStream>(){

                @Override
                public FSDataInputStream call() throws Exception {
                    inputStream.seek(-1L);
                    return inputStream;
                }
            });
            ITestAzureBlobFileSystemRandomRead.assertTrue((String)("Test file length only " + testFileLength), (testFileLength > 0L ? 1 : 0) != 0);
            inputStream.seek(testFileLength);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)testFileLength, (long)inputStream.getPos());
            LambdaTestUtils.intercept(EOFException.class, (String)"Attempted to seek or read past the end of the file", (Callable)new Callable<FSDataInputStream>(){

                @Override
                public FSDataInputStream call() throws Exception {
                    inputStream.seek(testFileLength + 1L);
                    return inputStream;
                }
            });
            long elapsedTimeMs = timer.elapsedTimeMs();
            ITestAzureBlobFileSystemRandomRead.assertTrue((String)String.format("There should not be any network I/O (elapsedTimeMs=%1$d).", elapsedTimeMs), (elapsedTimeMs < 20L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSeekAndAvailableAndPosition() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            byte[] expected1 = new byte[]{97, 98, 99};
            byte[] expected2 = new byte[]{100, 101, 102};
            byte[] expected3 = new byte[]{98, 99, 100};
            byte[] expected4 = new byte[]{103, 104, 105};
            byte[] buffer = new byte[3];
            int bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected1, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected2, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(2 * buffer.length), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            int seekPos = 0;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected1, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            seekPos = 1;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected3, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            seekPos = 6;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected4, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
        }
    }

    @Test
    public void testSkipAndAvailableAndPosition() throws Exception {
        this.assumeHugeFileExists();
        try (FSDataInputStream inputStream = this.getFileSystem().open(TEST_FILE_PATH);){
            byte[] expected1 = new byte[]{97, 98, 99};
            byte[] expected2 = new byte[]{100, 101, 102};
            byte[] expected3 = new byte[]{98, 99, 100};
            byte[] expected4 = new byte[]{103, 104, 105};
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)testFileLength, (long)inputStream.available());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)0L, (long)inputStream.getPos());
            int n = 3;
            long skipped = inputStream.skip((long)n);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)skipped, (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)skipped, (long)n);
            byte[] buffer = new byte[3];
            int bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected2, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)((long)buffer.length + skipped), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            int seekPos = 1;
            inputStream.seek((long)seekPos);
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected3, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(buffer.length + seekPos), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            long currentPosition = inputStream.getPos();
            n = 2;
            skipped = inputStream.skip((long)n);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(currentPosition + skipped), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)skipped, (long)n);
            bytesRead = inputStream.read(buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)buffer.length, (long)bytesRead);
            ITestAzureBlobFileSystemRandomRead.assertArrayEquals((byte[])expected4, (byte[])buffer);
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)((long)buffer.length + skipped + currentPosition), (long)inputStream.getPos());
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)(testFileLength - inputStream.getPos()), (long)inputStream.available());
        }
    }

    @Test
    public void testSequentialReadAfterReverseSeekPerformance() throws Exception {
        this.assumeHugeFileExists();
        int maxAttempts = 10;
        double maxAcceptableRatio = 1.01;
        double beforeSeekElapsedMs = 0.0;
        double afterSeekElapsedMs = 0.0;
        double ratio = Double.MAX_VALUE;
        for (int i = 0; i < 10 && ratio >= 1.01; ++i) {
            beforeSeekElapsedMs = this.sequentialRead(ABFS, (FileSystem)this.getFileSystem(), false);
            afterSeekElapsedMs = this.sequentialRead(ABFS, (FileSystem)this.getFileSystem(), true);
            ratio = afterSeekElapsedMs / beforeSeekElapsedMs;
            LOG.info(String.format("beforeSeekElapsedMs=%1$d, afterSeekElapsedMs=%2$d, ratio=%3$.2f", (long)beforeSeekElapsedMs, (long)afterSeekElapsedMs, ratio));
        }
        ITestAzureBlobFileSystemRandomRead.assertTrue((String)String.format("Performance of ABFS stream after reverse seek is not acceptable: beforeSeekElapsedMs=%1$d, afterSeekElapsedMs=%2$d, ratio=%3$.2f", (long)beforeSeekElapsedMs, (long)afterSeekElapsedMs, ratio), (ratio < 1.01 ? 1 : 0) != 0);
    }

    @Test
    public void testRandomReadPerformance() throws Exception {
        Assume.assumeFalse((String)"This test does not support namespace enabled account", (boolean)this.getFileSystem().getIsNamespaceEnabled());
        this.createTestFile();
        this.assumeHugeFileExists();
        AzureBlobFileSystem abFs = this.getFileSystem();
        NativeAzureFileSystem wasbFs = this.getWasbFileSystem();
        int maxAttempts = 10;
        double maxAcceptableRatio = 1.025;
        double v1ElapsedMs = 0.0;
        double v2ElapsedMs = 0.0;
        double ratio = Double.MAX_VALUE;
        for (int i = 0; i < 10 && ratio >= 1.025; ++i) {
            v1ElapsedMs = this.randomRead(1, (FileSystem)wasbFs);
            v2ElapsedMs = this.randomRead(2, (FileSystem)abFs);
            ratio = v2ElapsedMs / v1ElapsedMs;
            LOG.info(String.format("v1ElapsedMs=%1$d, v2ElapsedMs=%2$d, ratio=%3$.2f", (long)v1ElapsedMs, (long)v2ElapsedMs, ratio));
        }
        ITestAzureBlobFileSystemRandomRead.assertTrue((String)String.format("Performance of version 2 is not acceptable: v1ElapsedMs=%1$d, v2ElapsedMs=%2$d, ratio=%3$.2f", (long)v1ElapsedMs, (long)v2ElapsedMs, ratio), (ratio < 1.025 ? 1 : 0) != 0);
    }

    private long sequentialRead(String version, FileSystem fs, boolean afterReverseSeek) throws IOException {
        byte[] buffer = new byte[16384];
        long bytesRead = 0L;
        try (FSDataInputStream inputStream = fs.open(TEST_FILE_PATH);){
            long totalBytesRead;
            if (afterReverseSeek) {
                for (totalBytesRead = 0L; bytesRead > 0L && totalBytesRead < 0x400000L; totalBytesRead += bytesRead) {
                    bytesRead = inputStream.read(buffer);
                }
                totalBytesRead = 0L;
                inputStream.seek(0L);
            }
            ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
            while ((bytesRead = (long)inputStream.read(buffer)) > 0L) {
                totalBytesRead += bytesRead;
            }
            long elapsedTimeMs = timer.elapsedTimeMs();
            LOG.info(String.format("v%1$s: bytesRead=%2$d, elapsedMs=%3$d, Mbps=%4$.2f, afterReverseSeek=%5$s", version, totalBytesRead, elapsedTimeMs, ITestAzureBlobFileSystemRandomRead.toMbps(totalBytesRead, elapsedTimeMs), afterReverseSeek));
            ITestAzureBlobFileSystemRandomRead.assertEquals((long)testFileLength, (long)totalBytesRead);
            inputStream.close();
            long l = elapsedTimeMs;
            return l;
        }
    }

    private long randomRead(int version, FileSystem fs) throws Exception {
        this.assumeHugeFileExists();
        long minBytesToRead = 0x200000L;
        Random random = new Random();
        byte[] buffer = new byte[8192];
        long totalBytesRead = 0L;
        long bytesRead = 0L;
        try (FSDataInputStream inputStream = fs.open(TEST_FILE_PATH);){
            ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
            do {
                bytesRead = inputStream.read(buffer);
                inputStream.seek((long)random.nextInt((int)(0x800000L - (long)buffer.length)));
            } while (bytesRead > 0L && (totalBytesRead += bytesRead) < 0x200000L);
            long elapsedTimeMs = timer.elapsedTimeMs();
            inputStream.close();
            LOG.info(String.format("v%1$d: totalBytesRead=%2$d, elapsedTimeMs=%3$d, Mbps=%4$.2f", version, totalBytesRead, elapsedTimeMs, ITestAzureBlobFileSystemRandomRead.toMbps(totalBytesRead, elapsedTimeMs)));
            ITestAzureBlobFileSystemRandomRead.assertTrue((0x200000L <= totalBytesRead ? 1 : 0) != 0);
            long l = elapsedTimeMs;
            return l;
        }
    }

    private static double toMbps(long bytes, long milliseconds) {
        return (double)bytes / 1000.0 * 8.0 / (double)milliseconds;
    }

    private void createTestFile() throws Exception {
        FileStatus status;
        AzureBlobFileSystem fs = this.getFileSystem();
        if (fs.exists(TEST_FILE_PATH) && (status = fs.getFileStatus(TEST_FILE_PATH)).getLen() >= 0x800000L) {
            return;
        }
        byte[] buffer = new byte[26624];
        int character = 97;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)character;
            character = (char)(character == 122 ? 97 : (char)(character + 1));
        }
        LOG.info(String.format("Creating test file %s of size: %d ", TEST_FILE_PATH, 0x800000L));
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        try (FSDataOutputStream outputStream = fs.create(TEST_FILE_PATH);){
            int bytesWritten = 0;
            while ((long)bytesWritten < 0x800000L) {
                outputStream.write(buffer);
                bytesWritten += buffer.length;
            }
            LOG.info("Closing stream {}", (Object)outputStream);
            ContractTestUtils.NanoTimer closeTimer = new ContractTestUtils.NanoTimer();
            outputStream.close();
            closeTimer.end("time to close() output stream", new Object[0]);
        }
        timer.end("time to write %d KB", new Object[]{8192L});
        testFileLength = fs.getFileStatus(TEST_FILE_PATH).getLen();
    }

    private void assumeHugeFileExists() throws Exception {
        this.createTestFile();
        AzureBlobFileSystem fs = this.getFileSystem();
        ContractTestUtils.assertPathExists((FileSystem)this.getFileSystem(), (String)"huge file not created", (Path)TEST_FILE_PATH);
        FileStatus status = fs.getFileStatus(TEST_FILE_PATH);
        ContractTestUtils.assertIsFile((Path)TEST_FILE_PATH, (FileStatus)status);
        ITestAzureBlobFileSystemRandomRead.assertTrue((String)("File " + TEST_FILE_PATH + " is empty"), (status.getLen() > 0L ? 1 : 0) != 0);
    }

    private void verifyConsistentReads(FSDataInputStream inputStreamV1, FSDataInputStream inputStreamV2, byte[] bufferV1, byte[] bufferV2) throws IOException {
        int size = bufferV1.length;
        int numBytesReadV1 = inputStreamV1.read(bufferV1, 0, size);
        ITestAzureBlobFileSystemRandomRead.assertEquals((String)"Bytes read from wasb stream", (long)size, (long)numBytesReadV1);
        int numBytesReadV2 = inputStreamV2.read(bufferV2, 0, size);
        ITestAzureBlobFileSystemRandomRead.assertEquals((String)"Bytes read from abfs stream", (long)size, (long)numBytesReadV2);
        ITestAzureBlobFileSystemRandomRead.assertArrayEquals((String)"Mismatch in read data", (byte[])bufferV1, (byte[])bufferV2);
    }
}

