/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestClientUrlScheme
extends AbstractAbfsIntegrationTest {
    @Parameterized.Parameter
    public boolean useSecureScheme;
    @Parameterized.Parameter(value=1)
    public boolean alwaysUseHttps;

    @Parameterized.Parameters
    public static Iterable<Object[]> params() {
        return Arrays.asList({false, false}, {false, true}, {true, true}, {true, false});
    }

    public ITestClientUrlScheme() throws Exception {
        Assume.assumeTrue((String)"ITestClientUrlScheme is skipped because auth type is not SharedKey", (this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
    }

    @Test
    public void testClientUrlScheme() throws Exception {
        String[] urlWithoutScheme = this.getTestUrl().split(":");
        String fsUrl = this.useSecureScheme ? "abfss:" + urlWithoutScheme[1] : "abfs:" + urlWithoutScheme[1];
        Configuration config = this.getRawConfiguration();
        config.set("fs.defaultFS", fsUrl.toString());
        config.setBoolean("fs.azure.always.use.https", this.alwaysUseHttps);
        AbfsClient client = this.getFileSystem(config).getAbfsClient();
        Field baseUrlField = AbfsClient.class.getDeclaredField("baseUrl");
        baseUrlField.setAccessible(true);
        String url = ((URL)baseUrlField.get(client)).toString();
        if (!this.useSecureScheme && !this.alwaysUseHttps) {
            Assert.assertTrue((boolean)url.startsWith("http"));
        } else {
            Assert.assertTrue((boolean)url.startsWith("https"));
        }
    }
}

