/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestGetNameSpaceEnabled
extends AbstractAbfsIntegrationTest {
    private boolean isUsingXNSAccount = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);

    @Test
    public void testXNSAccount() throws IOException {
        Assume.assumeTrue((String)"Skip this test because the account being used for test is a non XNS account", (boolean)this.isUsingXNSAccount);
        ITestGetNameSpaceEnabled.assertTrue((String)"Expecting getIsNamespaceEnabled() return true", (boolean)this.getFileSystem().getIsNamespaceEnabled());
    }

    @Test
    public void testNonXNSAccount() throws IOException {
        Assume.assumeFalse((String)"Skip this test because the account being used for test is a XNS account", (boolean)this.isUsingXNSAccount);
        ITestGetNameSpaceEnabled.assertFalse((String)"Expecting getIsNamespaceEnabled() return false", (boolean)this.getFileSystem().getIsNamespaceEnabled());
    }

    @Test
    public void testFailedRequestWhenFSNotExist() throws Exception {
        AbfsConfiguration config = this.getConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        String testUri = this.getTestUrl();
        String nonExistingFsUrl = this.getAbfsScheme() + "://" + UUID.randomUUID() + testUri.substring(testUri.indexOf("@"));
        AzureBlobFileSystem fs = this.getFileSystem(nonExistingFsUrl);
        LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)"\"The specified filesystem does not exist.\", 404", () -> fs.getIsNamespaceEnabled());
    }

    @Test
    public void testFailedRequestWhenCredentialsNotCorrect() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
        Configuration config = this.getRawConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", false);
        String accountName = this.getAccountName();
        String configkKey = "fs.azure.account.key." + accountName;
        String secret = config.get(configkKey);
        secret = (char)(secret.charAt(0) + '\u0001') + secret.substring(1);
        config.set(configkKey, secret);
        AzureBlobFileSystem fs = this.getFileSystem(config);
        LambdaTestUtils.intercept(AbfsRestOperationException.class, (String)"\"Server failed to authenticate the request. Make sure the value of Authorization header is formed correctly including the signature.\", 403", () -> fs.getIsNamespaceEnabled());
    }
}

