/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestWasbAbfsCompatibility
extends AbstractAbfsIntegrationTest {
    private static final String WASB_TEST_CONTEXT = "wasb test file";
    private static final String ABFS_TEST_CONTEXT = "abfs test file";
    private static final String TEST_CONTEXT = "THIS IS FOR TEST";
    private static final Logger LOG = LoggerFactory.getLogger(ITestWasbAbfsCompatibility.class);

    public ITestWasbAbfsCompatibility() throws Exception {
        Assume.assumeFalse((String)"Emulator is not supported", (boolean)this.isIPAddress());
    }

    @Test
    public void testListFileStatus() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeFalse((String)"Namespace enabled account does not support this test,", (boolean)fs.getIsNamespaceEnabled());
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path path1 = new Path("/testfiles/~12/!008/3/abFsTestfile");
        try (FSDataOutputStream abfsStream = fs.create(path1, true);){
            abfsStream.write(ABFS_TEST_CONTEXT.getBytes());
            abfsStream.flush();
            abfsStream.hsync();
        }
        Path path2 = new Path("/testfiles/~12/!008/3/nativeFsTestfile");
        LOG.info("{}", (Object)wasb.getUri());
        try (FSDataOutputStream nativeFsStream = wasb.create(path2, true);){
            nativeFsStream.write(WASB_TEST_CONTEXT.getBytes());
            nativeFsStream.flush();
            nativeFsStream.hsync();
        }
        FileStatus[] abfsFileStatus = fs.listStatus(new Path("/testfiles/~12/!008/3/"));
        FileStatus[] nativeFsFileStatus = wasb.listStatus(new Path("/testfiles/~12/!008/3/"));
        ITestWasbAbfsCompatibility.assertEquals((long)2L, (long)abfsFileStatus.length);
        ITestWasbAbfsCompatibility.assertEquals((long)2L, (long)nativeFsFileStatus.length);
    }

    @Test
    public void testReadFile() throws Exception {
        boolean[] createFileWithAbfs = new boolean[]{false, true, false, true};
        boolean[] readFileWithAbfs = new boolean[]{false, true, true, false};
        AzureBlobFileSystem abfs = this.getFileSystem();
        Assume.assumeFalse((String)"Namespace enabled account does not support this test", (boolean)abfs.getIsNamespaceEnabled());
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        for (int i = 0; i < 4; ++i) {
            Path path = new Path("/testReadFile/~12/!008/testfile" + i);
            AzureBlobFileSystem createFs = createFileWithAbfs[i] ? abfs : wasb;
            try (FSDataOutputStream nativeFsStream = createFs.create(path, true);){
                nativeFsStream.write(TEST_CONTEXT.getBytes());
                nativeFsStream.flush();
                nativeFsStream.hsync();
            }
            ContractTestUtils.assertIsFile((FileSystem)createFs, (Path)path);
            AzureBlobFileSystem readFs = readFileWithAbfs[i] ? abfs : wasb;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)readFs.open(path)));){
                String line = br.readLine();
                ITestWasbAbfsCompatibility.assertEquals((String)("Wrong text from " + readFs), (Object)TEST_CONTEXT, (Object)line);
            }
            ContractTestUtils.assertDeleted((FileSystem)readFs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testDir() throws Exception {
        boolean[] createDirWithAbfs = new boolean[]{false, true, false, true};
        boolean[] readDirWithAbfs = new boolean[]{false, true, true, false};
        AzureBlobFileSystem abfs = this.getFileSystem();
        Assume.assumeFalse((String)"Namespace enabled account does not support this test", (boolean)abfs.getIsNamespaceEnabled());
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        for (int i = 0; i < 4; ++i) {
            Path path = new Path("/testDir/t" + i);
            AzureBlobFileSystem createFs = createDirWithAbfs[i] ? abfs : wasb;
            ITestWasbAbfsCompatibility.assertTrue((boolean)createFs.mkdirs(path));
            ContractTestUtils.assertPathExists((FileSystem)createFs, (String)("Created dir not found with " + createFs), (Path)path);
            AzureBlobFileSystem readFs = readDirWithAbfs[i] ? abfs : wasb;
            ContractTestUtils.assertPathExists((FileSystem)readFs, (String)("Created dir not found with " + readFs), (Path)path);
            ContractTestUtils.assertIsDirectory((FileSystem)readFs, (Path)path);
            ContractTestUtils.assertDeleted((FileSystem)readFs, (Path)path, (boolean)true);
        }
    }

    @Test
    public void testUrlConversion() {
        String abfsUrl = "abfs://abcde-1111-1111-1111-1111@xxxx.dfs.xxx.xxx.xxxx.xxxx";
        String wabsUrl = "wasb://abcde-1111-1111-1111-1111@xxxx.blob.xxx.xxx.xxxx.xxxx";
        ITestWasbAbfsCompatibility.assertEquals((Object)abfsUrl, (Object)ITestWasbAbfsCompatibility.wasbUrlToAbfsUrl(wabsUrl));
        ITestWasbAbfsCompatibility.assertEquals((Object)wabsUrl, (Object)ITestWasbAbfsCompatibility.abfsUrlToWasbUrl(abfsUrl));
    }

    @Test
    public void testSetWorkingDirectory() throws Exception {
        AzureBlobFileSystem abfs = this.getFileSystem();
        Assume.assumeFalse((String)"Namespace enabled account does not support this test", (boolean)abfs.getIsNamespaceEnabled());
        NativeAzureFileSystem wasb = this.getWasbFileSystem();
        Path d1d4 = new Path("/d1/d2/d3/d4");
        ContractTestUtils.assertMkdirs((FileSystem)abfs, (Path)d1d4);
        Path path1 = new Path("/d1/d2");
        wasb.setWorkingDirectory(path1);
        abfs.setWorkingDirectory(path1);
        ITestWasbAbfsCompatibility.assertEquals((Object)path1, (Object)wasb.getWorkingDirectory());
        ITestWasbAbfsCompatibility.assertEquals((Object)path1, (Object)abfs.getWorkingDirectory());
        Path path2 = new Path("d3/d4");
        wasb.setWorkingDirectory(path2);
        abfs.setWorkingDirectory(path2);
        Path path3 = d1d4;
        ITestWasbAbfsCompatibility.assertEquals((Object)path3, (Object)wasb.getWorkingDirectory());
        ITestWasbAbfsCompatibility.assertEquals((Object)path3, (Object)abfs.getWorkingDirectory());
    }
}

