/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.junit.Assert;
import org.junit.Test;

public class TestAccountConfiguration {
    @Test
    public void testStringPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.configuration";
        String accountKey1 = "fs.azure.configuration.account1";
        String accountKey2 = "fs.azure.configuration.account2";
        String accountKey3 = "fs.azure.configuration.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.configuration.account1", "one");
        conf.set("fs.azure.configuration.account2", "two");
        conf.set("fs.azure.configuration", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one");
        Assert.assertEquals((String)"Account-specific value was not returned when one existed", (Object)abfsConf.get("fs.azure.configuration"), (Object)"one");
        abfsConf = new AbfsConfiguration(conf, "account2");
        Assert.assertEquals((String)"Wrong value returned when a different account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account2"), (Object)"two");
        Assert.assertEquals((String)"Account-agnostic value return even though account-specific value was set", (Object)abfsConf.get("fs.azure.configuration"), (Object)"two");
        abfsConf = new AbfsConfiguration(conf, "account3");
        Assert.assertNull((String)"Account-specific value returned when none was set", (Object)abfsConf.get("fs.azure.configuration.account3"));
        Assert.assertEquals((String)"Account-agnostic value not returned when no account-specific value was set", (Object)abfsConf.get("fs.azure.configuration"), (Object)"global");
    }

    @Test
    public void testPasswordPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.password";
        String accountKey1 = "fs.azure.password.account1";
        String accountKey2 = "fs.azure.password.account2";
        String accountKey3 = "fs.azure.password.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.password.account1", "one");
        conf.set("fs.azure.password.account2", "two");
        conf.set("fs.azure.password", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one");
        Assert.assertEquals((String)"Account-specific value was not returned when one existed", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"one");
        abfsConf = new AbfsConfiguration(conf, "account2");
        Assert.assertEquals((String)"Wrong value returned when a different account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account2"), (Object)"two");
        Assert.assertEquals((String)"Account-agnostic value return even though account-specific value was set", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"two");
        abfsConf = new AbfsConfiguration(conf, "account3");
        Assert.assertNull((String)"Account-specific value returned when none was set", (Object)abfsConf.getPasswordString("fs.azure.password.account3"));
        Assert.assertEquals((String)"Account-agnostic value not returned when no account-specific value was set", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"global");
    }

    @Test
    public void testBooleanPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.bool";
        String accountKey = "fs.azure.bool.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setBoolean("fs.azure.bool", false);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false);
        conf.unset("fs.azure.bool");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true);
        conf.setBoolean("fs.azure.bool.account", false);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false);
        conf.unset("fs.azure.bool.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true);
        conf.setBoolean("fs.azure.bool.account", true);
        conf.setBoolean("fs.azure.bool", false);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getBoolean("fs.azure.bool", false), (Object)true);
    }

    @Test
    public void testLongPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.long";
        String accountKey = "fs.azure.long.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setLong("fs.azure.long", 0L);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (long)abfsConf.getLong("fs.azure.long", 1L), (long)0L);
        conf.unset("fs.azure.long");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (long)abfsConf.getLong("fs.azure.long", 1L), (long)1L);
        conf.setLong("fs.azure.long.account", 0L);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (long)abfsConf.getLong("fs.azure.long", 1L), (long)0L);
        conf.unset("fs.azure.long.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (long)abfsConf.getLong("fs.azure.long", 1L), (long)1L);
        conf.setLong("fs.azure.long.account", 1L);
        conf.setLong("fs.azure.long", 0L);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (long)abfsConf.getLong("fs.azure.long", 0L), (long)1L);
    }

    @Test
    public void testEnumPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.enum";
        String accountKey = "fs.azure.enum.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE));
        conf.unset("fs.azure.enum");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE));
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE));
        conf.unset("fs.azure.enum.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE));
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.TRUE);
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.FALSE), (Object)((Object)GetEnumType.TRUE));
    }

    @Test
    public void testClassPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.class";
        String accountKey = "fs.azure.class.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        Class<GetClassImpl0> class0 = GetClassImpl0.class;
        Class<GetClassImpl1> class1 = GetClassImpl1.class;
        Class<GetClassInterface> xface = GetClassInterface.class;
        conf.setClass("fs.azure.class", class0, xface);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getClass("fs.azure.class", class1, xface), class0);
        conf.unset("fs.azure.class");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getClass("fs.azure.class", class1, xface), class1);
        conf.setClass("fs.azure.class.account", class0, xface);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getClass("fs.azure.class", class1, xface), class0);
        conf.unset("fs.azure.class.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getClass("fs.azure.class", class1, xface), class1);
        conf.setClass("fs.azure.class.account", class1, xface);
        conf.setClass("fs.azure.class", class0, xface);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getClass("fs.azure.class", class0, xface), class1);
    }

    private class GetClassImpl1
    implements GetClassInterface {
        private GetClassImpl1() {
        }
    }

    private class GetClassImpl0
    implements GetClassInterface {
        private GetClassImpl0() {
        }
    }

    static interface GetClassInterface {
    }

    public static enum GetEnumType {
        TRUE,
        FALSE;

    }
}

