/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.contract.AbstractBondedFSContract;

public class AbfsFileSystemContract
extends AbstractBondedFSContract {
    public static final String CONTRACT_XML = "abfs.xml";
    private final boolean isSecure;

    protected AbfsFileSystemContract(Configuration conf, boolean secure) {
        super(conf);
        this.addConfResource(CONTRACT_XML);
        this.isSecure = secure;
    }

    public String getScheme() {
        return this.isSecure ? "abfss" : "abfs";
    }

    public Path getTestPath() {
        return new Path(UriUtils.generateUniqueTestPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbfsFileSystemContract{");
        sb.append("isSecureScheme=").append(this.isSecure);
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

