/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.contract.ABFSContractTestBinding;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ITestAzureBlobFileSystemBasics
extends FileSystemContractBaseTest {
    private final ABFSContractTestBinding binding = new ABFSContractTestBinding(false);

    @Before
    public void setUp() throws Exception {
        this.binding.setup();
        this.fs = this.binding.getFileSystem();
    }

    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this.binding.teardown();
        }
    }

    @Test
    public void testListOnFolderWithNoChildren() throws IOException {
        Assert.assertTrue((boolean)this.fs.mkdirs(this.path("testListStatus/c/1")));
        FileStatus[] paths = this.fs.listStatus(this.path("testListStatus"));
        Assert.assertEquals((long)1L, (long)paths.length);
        paths = this.fs.listStatus(this.path("testListStatus/c"));
        Assert.assertEquals((long)1L, (long)paths.length);
        this.fs.delete(this.path("testListStatus/c/1"), true);
        paths = this.fs.listStatus(this.path("testListStatus/c"));
        Assert.assertEquals((long)0L, (long)paths.length);
        Assert.assertTrue((boolean)this.fs.delete(this.path("testListStatus"), true));
    }

    @Test
    public void testListOnfileAndFolder() throws IOException {
        Path folderPath = this.path("testListStatus/folder");
        Path filePath = this.path("testListStatus/file");
        Assert.assertTrue((boolean)this.fs.mkdirs(folderPath));
        ContractTestUtils.touch((FileSystem)this.fs, (Path)filePath);
        FileStatus[] listFolderStatus = this.fs.listStatus(this.path("testListStatus"));
        Assert.assertEquals((Object)filePath, (Object)listFolderStatus[0].getPath());
        FileStatus[] listFileStatus = this.fs.listStatus(filePath);
        Assert.assertEquals((Object)filePath, (Object)listFileStatus[0].getPath());
    }

    @Ignore(value="Not implemented in ABFS yet")
    public void testMkdirsWithUmask() throws Exception {
    }
}

