/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;

public interface FSWrapper {
    public void setWorkingDirectory(Path var1) throws IOException;

    public Path getWorkingDirectory();

    public Path makeQualified(Path var1);

    public FSDataOutputStream create(Path var1, EnumSet<CreateFlag> var2, Options.CreateOpts ... var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException;

    public void mkdir(Path var1, FsPermission var2, boolean var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException;

    public boolean delete(Path var1, boolean var2) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public FSDataInputStream open(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public boolean setReplication(Path var1, short var2) throws AccessControlException, FileNotFoundException, IOException;

    public void rename(Path var1, Path var2, Options.Rename ... var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException;

    public void setPermission(Path var1, FsPermission var2) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public void setOwner(Path var1, String var2, String var3) throws AccessControlException, UnsupportedFileSystemException, FileNotFoundException, IOException;

    public void setTimes(Path var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public FileChecksum getFileChecksum(Path var1) throws AccessControlException, FileNotFoundException, IOException;

    public FileStatus getFileStatus(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public FileStatus getFileLinkStatus(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public Path getLinkTarget(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public BlockLocation[] getFileBlockLocations(Path var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public void createSymlink(Path var1, Path var2, boolean var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException;

    public RemoteIterator<FileStatus> listStatusIterator(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public FileStatus[] listStatus(Path var1) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException;

    public FileStatus[] globStatus(Path var1, PathFilter var2) throws IOException;
}

