/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedDataStreamer;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripedFileTestUtil {
    public static final Logger LOG = LoggerFactory.getLogger(StripedFileTestUtil.class);

    public static byte[] generateBytes(int cnt) {
        byte[] bytes = new byte[cnt];
        for (int i = 0; i < cnt; ++i) {
            bytes[i] = StripedFileTestUtil.getByte(i);
        }
        return bytes;
    }

    static byte getByte(long pos) {
        int mod = 29;
        return (byte)(pos % 29L + 1L);
    }

    static void verifyLength(FileSystem fs, Path srcPath, int fileLength) throws IOException {
        FileStatus status = fs.getFileStatus(srcPath);
        Assert.assertEquals((String)"File length should be the same", (long)fileLength, (long)status.getLen());
    }

    static void verifyPread(DistributedFileSystem fs, Path srcPath, int fileLength, byte[] expected, byte[] buf) throws IOException {
        ErasureCodingPolicy ecPolicy = fs.getErasureCodingPolicy(srcPath);
        StripedFileTestUtil.verifyPread((FileSystem)fs, srcPath, fileLength, expected, buf, ecPolicy);
    }

    static void verifyPread(FileSystem fs, Path srcPath, int fileLength, byte[] expected, byte[] buf, ErasureCodingPolicy ecPolicy) throws IOException {
        try (FSDataInputStream in = fs.open(srcPath);){
            int[] startOffsets;
            for (int startOffset : startOffsets = new int[]{0, 1, ecPolicy.getCellSize() - 102, ecPolicy.getCellSize(), ecPolicy.getCellSize() + 102, ecPolicy.getCellSize() * (ecPolicy.getNumDataUnits() - 1), ecPolicy.getCellSize() * (ecPolicy.getNumDataUnits() - 1) + 102, ecPolicy.getCellSize() * ecPolicy.getNumDataUnits(), fileLength - 102, fileLength - 1}) {
                startOffset = Math.max(0, Math.min(startOffset, fileLength - 1));
                int remaining = fileLength - startOffset;
                int offset = startOffset;
                byte[] result = new byte[remaining];
                while (remaining > 0) {
                    int target = Math.min(remaining, buf.length);
                    in.readFully((long)offset, buf, 0, target);
                    System.arraycopy(buf, 0, result, offset - startOffset, target);
                    remaining -= target;
                    offset += target;
                }
                for (int i = 0; i < fileLength - startOffset; ++i) {
                    Assert.assertEquals((String)("Byte at " + (startOffset + i) + " is different, the startOffset is " + startOffset), (long)expected[startOffset + i], (long)result[i]);
                }
            }
        }
    }

    static void verifyStatefulRead(FileSystem fs, Path srcPath, int fileLength, byte[] expected, byte[] buf) throws IOException {
        try (FSDataInputStream in = fs.open(srcPath);){
            int ret;
            byte[] result = new byte[fileLength];
            int readLen = 0;
            while ((ret = in.read(buf, 0, buf.length)) >= 0) {
                System.arraycopy(buf, 0, result, readLen, ret);
                readLen += ret;
            }
            Assert.assertEquals((String)"The length of file should be the same to write size", (long)fileLength, (long)readLen);
            Assert.assertArrayEquals((byte[])expected, (byte[])result);
        }
    }

    static void verifyStatefulRead(FileSystem fs, Path srcPath, int fileLength, byte[] expected, ByteBuffer buf) throws IOException {
        try (FSDataInputStream in = fs.open(srcPath);){
            int ret;
            ByteBuffer result = ByteBuffer.allocate(fileLength);
            int readLen = 0;
            while ((ret = in.read(buf)) >= 0) {
                readLen += ret;
                buf.flip();
                result.put(buf);
                buf.clear();
            }
            Assert.assertEquals((String)"The length of file should be the same to write size", (long)fileLength, (long)readLen);
            Assert.assertArrayEquals((byte[])expected, (byte[])result.array());
        }
    }

    static void verifySeek(FileSystem fs, Path srcPath, int fileLength, ErasureCodingPolicy ecPolicy, int blkGroupSize) throws IOException {
        block19: {
            try (FSDataInputStream in = fs.open(srcPath);){
                int pos = fileLength / 2;
                StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                pos = fileLength / 3;
                StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                pos = 0;
                StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                if (fileLength > ecPolicy.getCellSize()) {
                    pos = ecPolicy.getCellSize() - 1;
                    StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                }
                if (fileLength > ecPolicy.getCellSize() * ecPolicy.getNumDataUnits()) {
                    pos = ecPolicy.getCellSize() * ecPolicy.getNumDataUnits() - 1;
                    StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                }
                if (fileLength > blkGroupSize) {
                    pos = blkGroupSize - 1;
                    StripedFileTestUtil.assertSeekAndRead(in, pos, fileLength);
                }
                if (in.getWrappedStream() instanceof WebHdfsFileSystem.WebHdfsInputStream) break block19;
                try {
                    in.seek(-1L);
                    Assert.fail((String)"Should be failed if seek to negative offset");
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                try {
                    in.seek((long)(fileLength + 1));
                    Assert.fail((String)"Should be failed if seek after EOF");
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }
    }

    static void assertSeekAndRead(FSDataInputStream fsdis, int pos, int writeBytes) throws IOException {
        fsdis.seek((long)pos);
        byte[] buf = new byte[writeBytes - pos];
        IOUtils.readFully((InputStream)fsdis, (byte[])buf, (int)0, (int)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Byte at " + i + " should be the same"), (long)StripedFileTestUtil.getByte(pos + i), (long)buf[i]);
        }
    }

    static void killDatanode(MiniDFSCluster cluster, DFSStripedOutputStream out, int dnIndex, AtomicInteger pos) {
        StripedDataStreamer s = out.getStripedDataStreamer(dnIndex);
        DatanodeInfo datanode = StripedFileTestUtil.getDatanodes(s);
        assert (datanode != null);
        LOG.info("killDatanode " + dnIndex + ": " + datanode + ", pos=" + pos);
        cluster.stopDataNode(datanode.getXferAddr());
    }

    static DatanodeInfo getDatanodes(StripedDataStreamer streamer) {
        while (true) {
            DatanodeInfo[] datanodes;
            if ((datanodes = streamer.getNodes()) != null) {
                Assert.assertEquals((long)1L, (long)datanodes.length);
                Assert.assertNotNull((Object)datanodes[0]);
                return datanodes[0];
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                return null;
            }
        }
    }

    public static short getRealDataBlockNum(int numBytesInStrip, ErasureCodingPolicy ecPolicy) {
        return (short)Math.min(ecPolicy.getNumDataUnits(), (numBytesInStrip - 1) / ecPolicy.getCellSize() + 1);
    }

    public static short getRealTotalBlockNum(int numBytesInStrip, ErasureCodingPolicy ecPolicy) {
        return (short)(StripedFileTestUtil.getRealDataBlockNum(numBytesInStrip, ecPolicy) + ecPolicy.getNumParityUnits());
    }

    public static void waitBlockGroupsReported(DistributedFileSystem fs, String src) throws Exception {
        StripedFileTestUtil.waitBlockGroupsReported(fs, src, 0);
    }

    public static void waitBlockGroupsReported(DistributedFileSystem fs, String src, int numDeadDNs) throws Exception {
        boolean success;
        int ATTEMPTS = 40;
        int count = 0;
        ErasureCodingPolicy ecPolicy = fs.getErasureCodingPolicy(new Path(src));
        do {
            success = true;
            ++count;
            LocatedBlocks lbs = fs.getClient().getLocatedBlocks(src, 0L);
            for (LocatedBlock lb : lbs.getLocatedBlocks()) {
                short expected = (short)(StripedFileTestUtil.getRealTotalBlockNum((int)lb.getBlockSize(), ecPolicy) - numDeadDNs);
                int reported = lb.getLocations().length;
                if (reported >= expected) continue;
                success = false;
                LOG.info("blockGroup " + lb.getBlock() + " of file " + src + " has reported internalBlocks " + reported + " (desired " + expected + "); locations " + Joiner.on((char)' ').join((Object[])lb.getLocations()));
                Thread.sleep(1000L);
                break;
            }
            if (!success) continue;
            LOG.info("All blockGroups of file " + src + " verified to have all internalBlocks.");
        } while (!success && count < 40);
        if (count == 40) {
            throw new TimeoutException("Timed out waiting for " + src + " to have all the internalBlocks");
        }
    }

    public static int[] randomArray(int min, int max, int n) {
        if (n > max - min + 1 || max < min || min < 0 || max < 0) {
            return null;
        }
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = -1;
        }
        int count = 0;
        while (count < n) {
            int num = (int)(Math.random() * (double)(max - min)) + min;
            boolean flag = true;
            for (int j = 0; j < n; ++j) {
                if (num != result[j]) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            result[count] = num;
            ++count;
        }
        return result;
    }

    public static void verifyLocatedStripedBlocks(LocatedBlocks lbs, int groupSize) {
        for (LocatedBlock lb : lbs.getLocatedBlocks()) {
            assert (lb instanceof LocatedStripedBlock);
            HashSet locs = new HashSet();
            Collections.addAll(locs, lb.getLocations());
            Assert.assertEquals((long)groupSize, (long)lb.getLocations().length);
            Assert.assertEquals((long)groupSize, (long)locs.size());
            byte[] blockIndices = ((LocatedStripedBlock)lb).getBlockIndices();
            Assert.assertEquals((long)groupSize, (long)blockIndices.length);
            HashSet<Integer> found = new HashSet<Integer>();
            for (byte index : blockIndices) {
                assert (index >= 0);
                found.add(Integer.valueOf(index));
            }
            Assert.assertEquals((long)groupSize, (long)found.size());
        }
    }

    static void checkData(DistributedFileSystem dfs, Path srcPath, int length, List<DatanodeInfo> killedList, List<Long> oldGSList, int blkGroupSize) throws IOException {
        StripedFileTestUtil.verifyLength((FileSystem)dfs, srcPath, length);
        ArrayList<List<LocatedBlock>> blockGroupList = new ArrayList<List<LocatedBlock>>();
        LocatedBlocks lbs = dfs.getClient().getLocatedBlocks(srcPath.toString(), 0L, Long.MAX_VALUE);
        if (length > 0) {
            int expectedNumGroup = (length - 1) / blkGroupSize + 1;
            Assert.assertEquals((long)expectedNumGroup, (long)lbs.getLocatedBlocks().size());
        }
        ErasureCodingPolicy ecPolicy = dfs.getErasureCodingPolicy(srcPath);
        int cellSize = ecPolicy.getCellSize();
        int dataBlkNum = ecPolicy.getNumDataUnits();
        int parityBlkNum = ecPolicy.getNumParityUnits();
        int index = 0;
        for (LocatedBlock firstBlock : lbs.getLocatedBlocks()) {
            Assert.assertTrue((boolean)(firstBlock instanceof LocatedStripedBlock));
            long gs = firstBlock.getBlock().getGenerationStamp();
            long oldGS = oldGSList != null ? oldGSList.get(index++) : -1L;
            String s = "gs=" + gs + ", oldGS=" + oldGS;
            LOG.info(s);
            Assert.assertTrue((String)s, (gs >= oldGS ? 1 : 0) != 0);
            LocatedBlock[] blocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)((LocatedStripedBlock)firstBlock), (int)cellSize, (int)dataBlkNum, (int)parityBlkNum);
            blockGroupList.add(Arrays.asList(blocks));
        }
        for (int group = 0; group < blockGroupList.size(); ++group) {
            boolean isLastGroup = group == blockGroupList.size() - 1;
            int groupSize = !isLastGroup ? blkGroupSize : length - (blockGroupList.size() - 1) * blkGroupSize;
            int numCellInGroup = (groupSize - 1) / cellSize + 1;
            int lastCellIndex = (numCellInGroup - 1) % dataBlkNum;
            int lastCellSize = groupSize - (numCellInGroup - 1) * cellSize;
            List blockList = (List)blockGroupList.get(group);
            byte[][] dataBlockBytes = new byte[dataBlkNum][];
            byte[][] parityBlockBytes = new byte[parityBlkNum][];
            HashSet<Integer> checkSet = new HashSet<Integer>();
            for (int i = 0; i < blockList.size(); ++i) {
                DatanodeInfo dn;
                int j = i >= dataBlkNum ? 0 : i;
                int numCellInBlock = (numCellInGroup - 1) / dataBlkNum + (j <= lastCellIndex ? 1 : 0);
                int blockSize = numCellInBlock * cellSize + (isLastGroup && j == lastCellIndex ? lastCellSize - cellSize : 0);
                byte[] blockBytes = new byte[blockSize];
                if (i < dataBlkNum) {
                    dataBlockBytes[i] = blockBytes;
                } else {
                    parityBlockBytes[i - dataBlkNum] = blockBytes;
                }
                LocatedBlock lb = (LocatedBlock)blockList.get(i);
                LOG.info("i,j=" + i + ", " + j + ", numCellInBlock=" + numCellInBlock + ", blockSize=" + blockSize + ", lb=" + lb);
                if (lb == null) continue;
                ExtendedBlock block = lb.getBlock();
                Assert.assertEquals((long)blockSize, (long)block.getNumBytes());
                if (block.getNumBytes() == 0L || killedList.contains(dn = ((LocatedBlock)blockList.get(i)).getLocations()[0])) continue;
                BlockReader blockReader = BlockReaderTestUtil.getBlockReader(dfs, lb, 0, block.getNumBytes());
                blockReader.readAll(blockBytes, 0, (int)block.getNumBytes());
                blockReader.close();
                checkSet.add(i);
            }
            LOG.info("Internal blocks to check: " + checkSet);
            int groupPosInFile = group * blkGroupSize;
            for (int i = 0; i < dataBlockBytes.length; ++i) {
                boolean killed = false;
                if (!checkSet.contains(i)) {
                    killed = true;
                }
                byte[] actual = dataBlockBytes[i];
                for (int posInBlk = 0; posInBlk < actual.length; ++posInBlk) {
                    long posInFile = StripedBlockUtil.offsetInBlkToOffsetInBG((int)cellSize, (int)dataBlkNum, (long)posInBlk, (int)i) + (long)groupPosInFile;
                    Assert.assertTrue((posInFile < (long)length ? 1 : 0) != 0);
                    byte expected = StripedFileTestUtil.getByte(posInFile);
                    if (killed) {
                        actual[posInBlk] = expected;
                        continue;
                    }
                    if (expected == actual[posInBlk]) continue;
                    String s = "expected=" + expected + " but actual=" + actual[posInBlk] + ", posInFile=" + posInFile + ", posInBlk=" + posInBlk + ". group=" + group + ", i=" + i;
                    Assert.fail((String)s);
                }
            }
            StripedFileTestUtil.verifyParityBlocks(dfs.getConf(), ((LocatedBlock)lbs.getLocatedBlocks().get(group)).getBlockSize(), cellSize, dataBlockBytes, parityBlockBytes, checkSet, ecPolicy.getCodecName());
        }
    }

    static void verifyParityBlocks(Configuration conf, long size, int cellSize, byte[][] dataBytes, byte[][] parityBytes, Set<Integer> checkSet, String codecName) {
        int i;
        int parityBlkSize = (int)StripedBlockUtil.getInternalBlockLength((long)size, (int)cellSize, (int)dataBytes.length, (int)dataBytes.length);
        byte[][] expectedParityBytes = new byte[parityBytes.length][];
        for (i = 0; i < parityBytes.length; ++i) {
            expectedParityBytes[i] = new byte[parityBlkSize];
        }
        for (i = 0; i < dataBytes.length; ++i) {
            if (dataBytes[i] == null) {
                dataBytes[i] = new byte[dataBytes[0].length];
                continue;
            }
            if (dataBytes[i].length >= dataBytes[0].length) continue;
            byte[] tmp = dataBytes[i];
            dataBytes[i] = new byte[dataBytes[0].length];
            System.arraycopy(tmp, 0, dataBytes[i], 0, tmp.length);
        }
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(dataBytes.length, parityBytes.length);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)codecName, (ErasureCoderOptions)coderOptions);
        try {
            encoder.encode(dataBytes, (byte[][])expectedParityBytes);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
        for (int i2 = 0; i2 < parityBytes.length; ++i2) {
            if (!checkSet.contains(i2 + dataBytes.length)) continue;
            Assert.assertArrayEquals((String)("i=" + i2), (byte[])expectedParityBytes[i2], (byte[])parityBytes[i2]);
        }
    }

    public static LocatedBlocks waitForReconstructionFinished(Path file, DistributedFileSystem fs, int groupSize) throws Exception {
        LOG.info("Waiting for reconstruction to be finished for the file:" + file + ", groupSize:" + groupSize);
        int attempts = 60;
        for (int i = 0; i < 60; ++i) {
            LocatedBlocks locatedBlocks = StripedFileTestUtil.getLocatedBlocks(file, fs);
            LocatedStripedBlock lastBlock = (LocatedStripedBlock)locatedBlocks.getLastLocatedBlock();
            DatanodeInfo[] storageInfos = lastBlock.getLocations();
            if (storageInfos.length >= groupSize) {
                return locatedBlocks;
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Time out waiting for EC block reconstruction.");
    }

    public static void waitForAllReconstructionFinished(Path file, DistributedFileSystem fs, long expectedBlocks) throws Exception {
        LOG.info("Waiting for reconstruction to be finished for the file:" + file + ", expectedBlocks:" + expectedBlocks);
        int attempts = 60;
        for (int i = 0; i < 60; ++i) {
            int totalBlocks = 0;
            LocatedBlocks locatedBlocks = StripedFileTestUtil.getLocatedBlocks(file, fs);
            for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
                DatanodeInfo[] storageInfos = locatedBlock.getLocations();
                totalBlocks += storageInfos.length;
            }
            if ((long)totalBlocks >= expectedBlocks) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Time out waiting for EC block reconstruction.");
    }

    public static LocatedBlocks getLocatedBlocks(Path file, DistributedFileSystem fs) throws IOException {
        return fs.getClient().getLocatedBlocks(file.toString(), 0L, Long.MAX_VALUE);
    }

    public static ErasureCodingPolicy getDefaultECPolicy() {
        return (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(0);
    }

    public static ErasureCodingPolicy getRandomNonDefaultECPolicy() {
        Random rand = new Random();
        List policies = SystemErasureCodingPolicies.getPolicies();
        return (ErasureCodingPolicy)policies.get(1 + rand.nextInt(policies.size() - 1));
    }

    public static Collection<Object[]> getECPolicies() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List policies = SystemErasureCodingPolicies.getPolicies();
        for (ErasureCodingPolicy policy : policies) {
            params.add(new Object[]{policy});
        }
        return params;
    }
}

