/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.diskbalancer.TestDiskBalancer;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.NullConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBalancerTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(TestDiskBalancer.class);
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    private static int[] diskSizes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 100, 200, 300, 400, 500, 600, 700, 800, 900};
    private Random rand = new Random(Time.monotonicNow());
    private String stringTable = "ABCDEDFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0987654321";

    private String getRandomName(int length) {
        StringBuilder name = new StringBuilder();
        for (int x = 0; x < length; ++x) {
            name.append(this.stringTable.charAt(this.rand.nextInt(this.stringTable.length())));
        }
        return name.toString();
    }

    private StorageType getRandomStorageType() {
        return StorageType.parseStorageType((int)this.rand.nextInt(3));
    }

    private long getRandomCapacity() {
        int size = diskSizes[this.rand.nextInt(diskSizes.length)];
        if (size < 10) {
            return (long)size * 0x10000000000L;
        }
        return (long)size * 0x40000000L;
    }

    private long getRandomReserved(long capacity) {
        double rcap = (double)capacity * 0.2;
        double randDouble = this.rand.nextDouble();
        double temp = randDouble * rcap;
        return new Double(temp).longValue();
    }

    private long getRandomDfsUsed(long capacity, long reserved) {
        double rcap = capacity - reserved;
        double randDouble = this.rand.nextDouble();
        double temp = randDouble * rcap;
        return new Double(temp).longValue();
    }

    public DiskBalancerVolume createRandomVolume() {
        return this.createRandomVolume(this.getRandomStorageType());
    }

    public DiskBalancerVolume createRandomVolume(StorageType type) {
        DiskBalancerVolume volume = new DiskBalancerVolume();
        volume.setPath("/tmp/disk/" + this.getRandomName(10));
        volume.setStorageType(type.toString());
        volume.setTransient(type.isTransient());
        volume.setCapacity(this.getRandomCapacity());
        volume.setReserved(this.getRandomReserved(volume.getCapacity()));
        volume.setUsed(this.getRandomDfsUsed(volume.getCapacity(), volume.getReserved()));
        volume.setUuid(UUID.randomUUID().toString());
        return volume;
    }

    public DiskBalancerVolumeSet createRandomVolumeSet(StorageType type, int diskCount) throws Exception {
        Preconditions.checkState((diskCount > 0 ? 1 : 0) != 0);
        DiskBalancerVolumeSet volumeSet = new DiskBalancerVolumeSet(type.isTransient());
        for (int x = 0; x < diskCount; ++x) {
            volumeSet.addVolume(this.createRandomVolume(type));
        }
        assert (volumeSet.getVolumeCount() == diskCount);
        return volumeSet;
    }

    public DiskBalancerDataNode createRandomDataNode(StorageType[] diskTypes, int diskCount) throws Exception {
        Preconditions.checkState((diskTypes.length > 0 ? 1 : 0) != 0);
        Preconditions.checkState((diskCount > 0 ? 1 : 0) != 0);
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        for (StorageType t : diskTypes) {
            DiskBalancerVolumeSet vSet = this.createRandomVolumeSet(t, diskCount);
            for (DiskBalancerVolume v : vSet.getVolumes()) {
                node.addVolume(v);
            }
        }
        return node;
    }

    public DiskBalancerCluster createRandCluster(int dataNodeCount, StorageType[] diskTypes, int diskCount) throws Exception {
        Preconditions.checkState((diskTypes.length > 0 ? 1 : 0) != 0);
        Preconditions.checkState((diskCount > 0 ? 1 : 0) != 0);
        Preconditions.checkState((dataNodeCount > 0 ? 1 : 0) != 0);
        NullConnector nullConnector = new NullConnector();
        DiskBalancerCluster cluster = new DiskBalancerCluster(nullConnector);
        for (int x = 0; x < dataNodeCount; ++x) {
            nullConnector.addNode(this.createRandomDataNode(diskTypes, diskCount));
        }
        cluster.readClusterInfo();
        return cluster;
    }

    public static int getBlockCount(FsVolumeSpi source, boolean checkblockPoolCount) throws IOException {
        int count = 0;
        for (String blockPoolID : source.getBlockPoolList()) {
            FsVolumeSpi.BlockIterator sourceIter = source.newBlockIterator(blockPoolID, "TestDiskBalancerSource");
            int blockCount = 0;
            while (!sourceIter.atEnd()) {
                ExtendedBlock block = sourceIter.nextBlock();
                if (block == null) continue;
                ++blockCount;
            }
            if (checkblockPoolCount) {
                LOG.info("Block Pool Id:  {}, blockCount: {}", (Object)blockPoolID, (Object)blockCount);
                Assert.assertTrue((blockCount > 0 ? 1 : 0) != 0);
            }
            count += blockCount;
        }
        return count;
    }

    public static MiniDFSCluster newImbalancedCluster(Configuration conf, int numDatanodes, long[] storageCapacities, int defaultBlockSize, int fileLen) throws IOException, InterruptedException, TimeoutException {
        return DiskBalancerTestUtil.newImbalancedCluster(conf, numDatanodes, storageCapacities, defaultBlockSize, fileLen, null);
    }

    public static MiniDFSCluster newImbalancedCluster(Configuration conf, int numDatanodes, long[] storageCapacities, int defaultBlockSize, int fileLen, HdfsServerConstants.StartupOption dnOption) throws IOException, InterruptedException, TimeoutException {
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        conf.setLong("dfs.blocksize", (long)defaultBlockSize);
        conf.setInt("dfs.bytes-per-checksum", defaultBlockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        String fileName = "/" + UUID.randomUUID().toString();
        Path filePath = new Path(fileName);
        Preconditions.checkNotNull((Object)storageCapacities);
        Preconditions.checkArgument((storageCapacities.length == 2 ? 1 : 0) != 0, (Object)"need to specify capacities for two storages.");
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf, basedir).numDataNodes(numDatanodes).storageCapacities(storageCapacities).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).dnStartupOption(dnOption).build();
        FsVolumeImpl source = null;
        FsVolumeImpl dest = null;
        cluster.waitActive();
        Random r = new Random();
        DistributedFileSystem fs = cluster.getFileSystem(0);
        TestBalancer.createFile((MiniDFSCluster)cluster, (Path)filePath, (long)fileLen, (short)1, (int)0);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        cluster.restartDataNodes();
        cluster.waitActive();
        for (int i = 0; i < numDatanodes; ++i) {
            DataNode dnNode = cluster.getDataNodes().get(i);
            try (FsDatasetSpi.FsVolumeReferences refs = dnNode.getFSDataset().getFsVolumeReferences();){
                source = (FsVolumeImpl)refs.get(0);
                dest = (FsVolumeImpl)refs.get(1);
                Assert.assertTrue((DiskBalancerTestUtil.getBlockCount(source, true) > 0 ? 1 : 0) != 0);
                DiskBalancerTestUtil.moveAllDataToDestVolume(dnNode.getFSDataset(), source, dest);
                Assert.assertEquals((long)0L, (long)DiskBalancerTestUtil.getBlockCount(source, false));
                continue;
            }
        }
        cluster.restartDataNodes();
        cluster.waitActive();
        return cluster;
    }

    public static void moveAllDataToDestVolume(FsDatasetSpi fsDataset, FsVolumeSpi source, FsVolumeSpi dest) throws IOException {
        for (String blockPoolID : source.getBlockPoolList()) {
            FsVolumeSpi.BlockIterator sourceIter = source.newBlockIterator(blockPoolID, "TestDiskBalancerSource");
            while (!sourceIter.atEnd()) {
                ExtendedBlock block = sourceIter.nextBlock();
                if (block == null) continue;
                fsDataset.moveBlockAcrossVolumes(block, dest);
            }
        }
    }
}

