/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.util.ReferenceCountMap;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;

@InterfaceAudience.Private
public class AclFeature
implements INode.Feature,
ReferenceCountMap.ReferenceCounter {
    public static final ImmutableList<AclEntry> EMPTY_ENTRY_LIST = ImmutableList.of();
    private int refCount = 0;
    private final int[] entries;

    public AclFeature(int[] entries) {
        this.entries = entries;
    }

    int getEntriesSize() {
        return this.entries.length;
    }

    int getEntryAt(int pos) {
        Preconditions.checkPositionIndex((int)pos, (int)this.entries.length, (String)"Invalid position for AclEntry");
        return this.entries[pos];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.entries, ((AclFeature)o).entries);
    }

    public String toString() {
        return "AclFeature : " + Integer.toHexString(this.hashCode()) + " Size of entries : " + this.entries.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    @Override
    public int getRefCount() {
        return this.refCount;
    }

    @Override
    public int incrementAndGetRefCount() {
        return ++this.refCount;
    }

    @Override
    public int decrementAndGetRefCount() {
        return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
    }
}

