/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementNeeded;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.ItemInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockStorageMovementAttemptedItems {
    private static final Logger LOG = LoggerFactory.getLogger(BlockStorageMovementAttemptedItems.class);
    private final List<StoragePolicySatisfier.AttemptedItemInfo> storageMovementAttemptedItems;
    private Map<Block, Set<StoragePolicySatisfier.StorageTypeNodePair>> scheduledBlkLocs;
    private final BlockingQueue<Block> movementFinishedBlocks;
    private volatile boolean monitorRunning = true;
    private Daemon timerThread = null;
    private final Context context;
    private long selfRetryTimeout = 300000L;
    private long minCheckTimeout = 60000L;
    private BlockStorageMovementNeeded blockStorageMovementNeeded;
    private final SPSService service;

    public BlockStorageMovementAttemptedItems(SPSService service, BlockStorageMovementNeeded unsatisfiedStorageMovementFiles, Context context) {
        this.service = service;
        long recheckTimeout = this.service.getConf().getLong("dfs.storage.policy.satisfier.recheck.timeout.millis", 60000L);
        if (recheckTimeout > 0L) {
            this.minCheckTimeout = Math.min(this.minCheckTimeout, recheckTimeout);
        }
        this.selfRetryTimeout = this.service.getConf().getLong("dfs.storage.policy.satisfier.self.retry.timeout.millis", 300000L);
        this.blockStorageMovementNeeded = unsatisfiedStorageMovementFiles;
        this.storageMovementAttemptedItems = new ArrayList<StoragePolicySatisfier.AttemptedItemInfo>();
        this.scheduledBlkLocs = new HashMap<Block, Set<StoragePolicySatisfier.StorageTypeNodePair>>();
        this.movementFinishedBlocks = new LinkedBlockingQueue<Block>();
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long startPathId, long fileId, long monotonicNow, Map<Block, Set<StoragePolicySatisfier.StorageTypeNodePair>> assignedBlocks, int retryCount) {
        StoragePolicySatisfier.AttemptedItemInfo itemInfo = new StoragePolicySatisfier.AttemptedItemInfo(startPathId, fileId, monotonicNow, assignedBlocks.keySet(), retryCount);
        Object object = this.storageMovementAttemptedItems;
        synchronized (object) {
            this.storageMovementAttemptedItems.add(itemInfo);
        }
        object = this.scheduledBlkLocs;
        synchronized (object) {
            this.scheduledBlkLocs.putAll(assignedBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReportedBlock(DatanodeInfo reportedDn, StorageType type, Block reportedBlock) {
        Map<Block, Set<StoragePolicySatisfier.StorageTypeNodePair>> map = this.scheduledBlkLocs;
        synchronized (map) {
            if (this.scheduledBlkLocs.size() <= 0) {
                return;
            }
            this.matchesReportedBlock(reportedDn, type, reportedBlock);
        }
    }

    private void matchesReportedBlock(DatanodeInfo reportedDn, StorageType type, Block reportedBlock) {
        Set<StoragePolicySatisfier.StorageTypeNodePair> blkLocs = this.scheduledBlkLocs.get(reportedBlock);
        if (blkLocs == null) {
            return;
        }
        for (StoragePolicySatisfier.StorageTypeNodePair dn : blkLocs) {
            boolean foundDn = dn.getDatanodeInfo().compareTo((DatanodeID)reportedDn) == 0;
            boolean foundType = dn.getStorageType().equals((Object)type);
            if (!foundDn || !foundType) continue;
            blkLocs.remove(dn);
            Block[] mFinishedBlocks = new Block[]{reportedBlock};
            this.context.notifyMovementTriedBlocks(mFinishedBlocks);
            if (blkLocs.size() <= 0) {
                this.movementFinishedBlocks.add(reportedBlock);
                this.scheduledBlkLocs.remove(reportedBlock);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reported block:{} not found in attempted blocks. Datanode:{}, StorageType:{}", new Object[]{reportedBlock, reportedDn, type});
        }
    }

    public synchronized void start() {
        this.monitorRunning = true;
        this.timerThread = new Daemon((Runnable)new BlocksStorageMovementAttemptMonitor());
        this.timerThread.setName("BlocksStorageMovementAttemptMonitor");
        this.timerThread.start();
    }

    public synchronized void stop() {
        this.monitorRunning = false;
        if (this.timerThread != null) {
            this.timerThread.interrupt();
        }
        this.clearQueues();
    }

    synchronized void stopGracefully() {
        if (this.timerThread == null) {
            return;
        }
        if (this.monitorRunning) {
            this.stop();
        }
        try {
            this.timerThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void blocksStorageMovementUnReportedItemsCheck() {
        List<StoragePolicySatisfier.AttemptedItemInfo> list = this.storageMovementAttemptedItems;
        synchronized (list) {
            Iterator<StoragePolicySatisfier.AttemptedItemInfo> iter = this.storageMovementAttemptedItems.iterator();
            long now = Time.monotonicNow();
            while (iter.hasNext()) {
                StoragePolicySatisfier.AttemptedItemInfo itemInfo = iter.next();
                if (now <= itemInfo.getLastAttemptedOrReportedTime() + this.selfRetryTimeout) continue;
                long file = itemInfo.getFile();
                ItemInfo candidate = new ItemInfo(itemInfo.getStartPath(), file, itemInfo.getRetryCount() + 1);
                this.blockStorageMovementNeeded.add(candidate);
                iter.remove();
                LOG.info("TrackID: {} becomes timed out and moved to needed retries queue for next iteration.", (Object)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void blockStorageMovementReportedItemsCheck() throws IOException {
        ArrayList finishedBlks = new ArrayList();
        this.movementFinishedBlocks.drainTo(finishedBlks);
        for (Block blk : finishedBlks) {
            List<StoragePolicySatisfier.AttemptedItemInfo> list = this.storageMovementAttemptedItems;
            synchronized (list) {
                Iterator<StoragePolicySatisfier.AttemptedItemInfo> iterator = this.storageMovementAttemptedItems.iterator();
                while (iterator.hasNext()) {
                    StoragePolicySatisfier.AttemptedItemInfo attemptedItemInfo = iterator.next();
                    attemptedItemInfo.getBlocks().remove(blk);
                    if (!attemptedItemInfo.getBlocks().isEmpty()) continue;
                    this.blockStorageMovementNeeded.add(new ItemInfo(attemptedItemInfo.getStartPath(), attemptedItemInfo.getFile(), attemptedItemInfo.getRetryCount() + 1));
                    iterator.remove();
                }
            }
        }
    }

    @VisibleForTesting
    public int getMovementFinishedBlocksCount() {
        return this.movementFinishedBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getAttemptedItemsCount() {
        List<StoragePolicySatisfier.AttemptedItemInfo> list = this.storageMovementAttemptedItems;
        synchronized (list) {
            return this.storageMovementAttemptedItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueues() {
        this.movementFinishedBlocks.clear();
        Object object = this.storageMovementAttemptedItems;
        synchronized (object) {
            this.storageMovementAttemptedItems.clear();
        }
        object = this.scheduledBlkLocs;
        synchronized (object) {
            this.scheduledBlkLocs.clear();
        }
    }

    private class BlocksStorageMovementAttemptMonitor
    implements Runnable {
        private BlocksStorageMovementAttemptMonitor() {
        }

        @Override
        public void run() {
            while (BlockStorageMovementAttemptedItems.this.monitorRunning) {
                try {
                    BlockStorageMovementAttemptedItems.this.blockStorageMovementReportedItemsCheck();
                    BlockStorageMovementAttemptedItems.this.blocksStorageMovementUnReportedItemsCheck();
                    Thread.sleep(BlockStorageMovementAttemptedItems.this.minCheckTimeout);
                }
                catch (InterruptedException ie) {
                    LOG.info("BlocksStorageMovementAttemptMonitor thread is interrupted.", (Throwable)ie);
                }
                catch (IOException ie) {
                    LOG.warn("BlocksStorageMovementAttemptMonitor thread received exception and exiting.", (Throwable)ie);
                }
            }
        }
    }
}

