/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSHAAdmin
extends HAAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(DFSHAAdmin.class);
    private String nameserviceId;

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected void setOut(PrintStream out) {
        this.out = out;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = DFSHAAdmin.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    public static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new HdfsConfiguration(conf);
        String nameNodePrincipal = conf.get("dfs.namenode.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using NN principal: " + nameNodePrincipal);
        }
        conf.set("hadoop.security.service.user.name.key", nameNodePrincipal);
        return conf;
    }

    protected HAServiceTarget resolveTarget(String nnId) {
        HdfsConfiguration conf = (HdfsConfiguration)this.getConf();
        return new NNHAServiceTarget((Configuration)conf, this.nameserviceId, nnId);
    }

    protected String getUsageString() {
        return "Usage: haadmin [-ns <nameserviceId>]";
    }

    protected int runCmd(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            this.printUsage(this.errOut);
            return -1;
        }
        int i = 0;
        if ("-ns".equals(cmd = argv[i++])) {
            if (i == argv.length) {
                this.errOut.println("Missing nameservice ID");
                this.printUsage(this.errOut);
                return -1;
            }
            this.nameserviceId = argv[i++];
            if (i >= argv.length) {
                this.errOut.println("Missing command");
                this.printUsage(this.errOut);
                return -1;
            }
            argv = Arrays.copyOfRange(argv, i, argv.length);
        }
        return super.runCmd(argv);
    }

    protected Collection<String> getTargetIds(String namenodeToActivate) {
        return DFSUtilClient.getNameNodeIds((Configuration)this.getConf(), (String)(this.nameserviceId != null ? this.nameserviceId : DFSUtil.getNamenodeNameServiceId(this.getConf())));
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new DFSHAAdmin(), (String[])argv);
        System.exit(res);
    }
}

