/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageHandler;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.hadoop.shaded.io.netty.channel.Channel;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInitializer;
import org.apache.hadoop.shaded.io.netty.channel.ChannelPipeline;
import org.apache.hadoop.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.shaded.io.netty.channel.group.ChannelGroup;
import org.apache.hadoop.shaded.io.netty.channel.group.DefaultChannelGroup;
import org.apache.hadoop.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.hadoop.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.string.StringEncoder;
import org.apache.hadoop.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebImageViewer
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(WebImageViewer.class);
    private Channel channel;
    private InetSocketAddress address;
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelGroup allChannels;
    private final Configuration conf;

    public WebImageViewer(InetSocketAddress address) {
        this(address, new Configuration());
    }

    public WebImageViewer(InetSocketAddress address, Configuration conf) {
        this.address = address;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    public void start(String fsimage) throws IOException {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                throw new RuntimeException("WebImageViewer does not support secure mode. To start in non-secure mode, pass -Dhadoop.security.authentication=simple");
            }
            this.initServer(fsimage);
            this.channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted. Stopping the WebImageViewer.");
            this.close();
        }
    }

    @VisibleForTesting
    public void initServer(String fsimage) throws IOException, InterruptedException {
        final FSImageLoader loader = FSImageLoader.load(fsimage);
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new HttpRequestDecoder(), new StringEncoder(), new HttpResponseEncoder(), new FSImageHandler(loader, WebImageViewer.this.allChannels));
            }
        });
        this.channel = this.bootstrap.bind(this.address).sync().channel();
        this.allChannels.add(this.channel);
        this.address = (InetSocketAddress)this.channel.localAddress();
        LOG.info("WebImageViewer started. Listening on " + this.address.toString() + ". Press Ctrl+C to stop the viewer.");
    }

    @VisibleForTesting
    public int getPort() {
        return this.address.getPort();
    }

    @Override
    public void close() {
        this.allChannels.close().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

