/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.guice.spi.container.servlet;

import java.util.Map;
import org.apache.hadoop.shaded.com.google.inject.Injector;
import org.apache.hadoop.shaded.com.google.inject.Scope;
import org.apache.hadoop.shaded.com.google.inject.servlet.ServletScopes;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.DefaultResourceConfig;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import org.apache.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentScope;
import org.apache.hadoop.shaded.com.sun.jersey.guice.spi.container.GuiceComponentProviderFactory;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.WebApplication;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.servlet.ServletContainer;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.servlet.WebConfig;
import org.apache.hadoop.shaded.javax.inject.Inject;
import org.apache.hadoop.shaded.javax.inject.Singleton;
import org.apache.hadoop.shaded.javax.servlet.ServletException;

@Singleton
public class GuiceContainer
extends ServletContainer {
    private static final long serialVersionUID = 1931878850157940335L;
    private final Injector injector;
    private WebApplication webapp;

    @Inject
    public GuiceContainer(Injector injector) {
        this.injector = injector;
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return new DefaultResourceConfig();
    }

    protected void initiate(ResourceConfig config, WebApplication webapp) {
        this.webapp = webapp;
        webapp.initiate(config, new ServletGuiceComponentProviderFactory(config, this.injector));
    }

    public WebApplication getWebApplication() {
        return this.webapp;
    }

    public class ServletGuiceComponentProviderFactory
    extends GuiceComponentProviderFactory {
        public ServletGuiceComponentProviderFactory(ResourceConfig config, Injector injector) {
            super(config, injector);
        }

        @Override
        public Map<Scope, ComponentScope> createScopeMap() {
            Map<Scope, ComponentScope> m = super.createScopeMap();
            m.put(ServletScopes.REQUEST, ComponentScope.PerRequest);
            return m;
        }
    }
}

