/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.DefaultValue;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.PathParam;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/applicationhistory")
public class AHSWebServices
extends WebServices {
    private static final Logger LOG = LoggerFactory.getLogger(AHSWebServices.class);
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Joiner DOT_JOINER = Joiner.on((String)". ");
    private final Configuration conf;
    private final LogAggregationFileControllerFactory factory;

    @Inject
    public AHSWebServices(ApplicationBaseProtocol appBaseProt, Configuration conf) {
        super(appBaseProt);
        this.conf = conf;
        this.factory = new LogAggregationFileControllerFactory(conf);
    }

    @GET
    @Path(value="/about")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TimelineAbout about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.initForReadableEndpoints(res);
        return TimelineUtils.createTimelineAbout((String)"Generic History Service API");
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo get(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        return this.getApps(req, res, null, Collections.emptySet(), null, null, null, null, null, null, null, null, Collections.emptySet());
    }

    @Override
    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes) {
        this.initForReadableEndpoints(res);
        AHSWebServices.validateStates(stateQuery, statesQuery);
        return super.getApps(req, res, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.initForReadableEndpoints(res);
        return super.getApp(req, res, appId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.initForReadableEndpoints(res);
        return super.getAppAttempts(req, res, appId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @Override
    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.initForReadableEndpoints(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    private static void validateStates(String stateQuery, Set<String> statesQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        Set<String> appStates = AHSWebServices.parseQueries(statesQuery, true);
        block3: for (String appState : appStates) {
            switch (YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)appState))) {
                case FINISHED: 
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            throw new BadRequestException("Invalid application-state " + appState + " specified. It should be a final state");
        }
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId = null;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return LogWebServiceUtils.getContainerLogMeta(this.factory, appId, null, null, containerIdStr, false);
        }
        if (LogWebServiceUtils.isFinishedState(appInfo.getAppState())) {
            return LogWebServiceUtils.getContainerLogMeta(this.factory, appId, null, null, containerIdStr, false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            String appOwner;
            block14: {
                appOwner = appInfo.getUser();
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.getContainerLogMeta(this.factory, appId, appOwner, null, containerIdStr, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return LogWebServiceUtils.getContainerLogMeta(this.factory, appId, appOwner, null, containerIdStr, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(this.conf, nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        throw new NotFoundException("The application is not at Running or Finished State.");
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") boolean redirected_from_node) {
        return this.getLogs(req, res, containerIdStr, filename, format, size, nmId, redirected_from_node);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "Invalid ContainerId: " + containerIdStr);
        }
        long length = LogWebServiceUtils.parseLongParam(size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return LogWebServiceUtils.sendStreamOutputResponse(this.factory, appId, null, null, containerIdStr, filename, format, length, false);
        }
        String appOwner = appInfo.getUser();
        if (LogWebServiceUtils.isFinishedState(appInfo.getAppState())) {
            return LogWebServiceUtils.sendStreamOutputResponse(this.factory, appId, appOwner, null, containerIdStr, filename, format, length, false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            block14: {
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.sendStreamOutputResponse(this.factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return LogWebServiceUtils.sendStreamOutputResponse(this.factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(this.conf, nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public String getNMWebAddressFromRM(Configuration configuration, String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        return LogWebServiceUtils.getNMWebAddressFromRM(configuration, nodeId);
    }
}

